/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.checkversion;

import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import ru.yoomoney.gradle.plugins.library.dependencies.ArtifactVersionResolver;
import ru.yoomoney.gradle.plugins.library.dependencies.checkversion.CheckVersionAction;
import ru.yoomoney.gradle.plugins.library.dependencies.checkversion.FindAllVersionConflictAction;
import ru.yoomoney.gradle.plugins.library.dependencies.checkversion.MajorVersionCheckerExtension;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

public class VersionChecker {
    public static void runCheckVersion(Project project, MajorVersionCheckerExtension majorVersionCheckerExtension, ArtifactVersionResolver artifactVersionResolver) {
        ConfigurationContainer allConfigurations = project.getConfigurations();
        Set excludedLibraries = majorVersionCheckerExtension.excludeDependencies.stream().map(LibraryName::parse).collect(Collectors.toSet());
        allConfigurations.stream().filter(VersionChecker::isValidConfiguration).forEach(conf -> {
            HashMap<LibraryName, Set<String>> conflictModules = new HashMap<LibraryName, Set<String>>();
            conf.getResolutionStrategy().eachDependency((Action)new FindAllVersionConflictAction(excludedLibraries, majorVersionCheckerExtension.includeGroupIdPrefixes, conflictModules, artifactVersionResolver)).eachDependency((Action)new CheckVersionAction(project, conflictModules, majorVersionCheckerExtension));
        });
    }

    private static boolean isValidConfiguration(Configuration configuration) {
        String configurationLowerName = configuration.getName().toLowerCase();
        return configurationLowerName.endsWith("compile") || configurationLowerName.endsWith("runtime") || Objects.equals(configurationLowerName, "compileclasspath");
    }
}

