/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.checkversion;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.checkversion.MajorVersionCheckerExtension;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;

class CheckVersionAction
implements Action<DependencyResolveDetails> {
    private static final Logger log = LoggerFactory.getLogger(CheckVersionAction.class);
    private final Project project;
    private final Map<LibraryName, Set<String>> conflictModules;
    private final Boolean failBuild;

    CheckVersionAction(Project project, Map<LibraryName, Set<String>> conflictModules, MajorVersionCheckerExtension majorVersionCheckerExtension) {
        this.project = project;
        this.conflictModules = conflictModules;
        this.failBuild = majorVersionCheckerExtension.failBuild;
    }

    public void execute(DependencyResolveDetails dependency) {
        LibraryName libraryName = new LibraryName(dependency.getRequested().getGroup(), dependency.getRequested().getName());
        if (this.conflictModules.containsKey(libraryName)) {
            String errorMsg = String.format("There is major version conflict for dependency=%s:%s, versions=%s", libraryName.getGroup(), libraryName.getName(), this.conflictModules.get(libraryName));
            log.error(errorMsg);
            if (this.failBuild.booleanValue() && !this.isDependenciesTask()) {
                throw new GradleException(errorMsg);
            }
        }
    }

    private boolean isDependenciesTask() {
        List taskNames = this.project.getGradle().getStartParameter().getTaskNames();
        return !taskNames.isEmpty() && ((String)taskNames.get(0)).endsWith("dependencies");
    }
}

