/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.ApproximateArtifactDependenciesAnalyzer;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.ConflictPathResolutionResult;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.VersionConflictInfo;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.VersionConflictResolver;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactDependency;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.VersionSelectors;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.Repository;

public class RepositoryVersionConflictResolver
implements VersionConflictResolver {
    private final Logger log = Logging.getLogger(RepositoryVersionConflictResolver.class);
    private final Repository repository;
    private final VersionSelectors versionSelectors;

    public RepositoryVersionConflictResolver(Repository repository, VersionSelectors versionSelectors) {
        this.repository = repository;
        this.versionSelectors = versionSelectors;
    }

    @Override
    public ConflictPathResolutionResult resolveConflict(VersionConflictInfo conflictInfo) {
        ArtifactName directDependency = conflictInfo.getDirectDependency();
        Set<String> alternativeVersions = this.findAlternativeVersions(directDependency);
        Set<String> suggestedVersions = this.findAppropriateVersions(conflictInfo, alternativeVersions);
        return new ConflictPathResolutionResult(directDependency, alternativeVersions, suggestedVersions);
    }

    private Set<String> findAlternativeVersions(ArtifactName artifactName) {
        Predicate<String> versionSelector = this.versionSelectors.forLibrary(artifactName.getLibraryName());
        return this.repository.findVersions(artifactName.getLibraryName()).stream().filter(versionSelector).collect(Collectors.toSet());
    }

    private Set<String> findAppropriateVersions(VersionConflictInfo conflictInfo, Set<String> directDependencyAlternativeVersions) {
        ArtifactName directDependency = conflictInfo.getDirectDependency();
        ArtifactName fixedDependency = conflictInfo.getTargetFixedDependency();
        if (directDependency.getLibraryName().equals(fixedDependency.getLibraryName())) {
            return directDependencyAlternativeVersions.contains(fixedDependency.getVersion()) ? Collections.singleton(fixedDependency.getVersion()) : Collections.emptySet();
        }
        ApproximateArtifactDependenciesAnalyzer<ArtifactDependency> dependenciesAnalyzer = new ApproximateArtifactDependenciesAnalyzer<ArtifactDependency>(this.repository, conflictInfo.getConflictPath());
        return directDependencyAlternativeVersions.stream().filter(version -> {
            ArtifactName alternativeDirectDependency = new ArtifactName(directDependency.getLibraryName(), (String)version);
            return !dependenciesAnalyzer.hasAnotherDependencyVersions(alternativeDirectDependency, fixedDependency.getLibraryName(), fixedDependency.getVersion());
        }).collect(Collectors.toSet());
    }
}

