/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.ArtifactDependenciesAnalyzer;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.Artifact;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.ArtifactName;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.DependencyPath;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.LibraryName;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.Repository;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.RepositoryArtifact;

public class ApproximateArtifactDependenciesAnalyzer<T extends Artifact<T>>
implements ArtifactDependenciesAnalyzer {
    private final Repository repository;
    private final DependencyPath<T> dependencyPathHint;

    public ApproximateArtifactDependenciesAnalyzer(Repository repository, DependencyPath<T> dependencyPathHint) {
        this.repository = repository;
        this.dependencyPathHint = dependencyPathHint;
    }

    @Override
    public boolean hasAnotherDependencyVersions(ArtifactName artifactName, LibraryName fixedDependency, String fixedVersion) {
        if (!this.getDirectDepenendencyHint().getLibraryName().equals(artifactName.getLibraryName())) {
            return false;
        }
        List transitiveDependencies = StreamSupport.stream(this.dependencyPathHint.spliterator(), false).skip(1L).collect(Collectors.toList());
        RepositoryArtifact currentArtifact = new RepositoryArtifact(this.repository, artifactName);
        for (Artifact hintDependency : transitiveDependencies) {
            RepositoryArtifact currentDependency = currentArtifact.getDependencies().stream().filter(dependency -> {
                LibraryName library = dependency.getName().getLibraryName();
                LibraryName hintLibrary = hintDependency.getName().getLibraryName();
                return library.equals(hintLibrary);
            }).findFirst().orElse(null);
            if (currentDependency == null) break;
            ArtifactName currentDependencyName = currentDependency.getName();
            if (currentDependencyName.getLibraryName().equals(fixedDependency)) {
                return !currentDependencyName.getVersion().equals(fixedVersion);
            }
            currentArtifact = currentDependency;
        }
        return false;
    }

    private ArtifactName getDirectDepenendencyHint() {
        return this.dependencyPathHint.getRoot().getName();
    }
}

