/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.library.dependencies.CheckDependenciesReporter;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.FixedDependencies;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.ConfigurationConflictsAnalyzer;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.ConflictVersionsChecker;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.ConflictedLibraryInfo;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.DummyVersionConflictResolver;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.RepositoryVersionConflictResolver;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.resolvers.VersionConflictResolver;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.VersionSelectors;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionRulesLoader;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.StaleExclusionsDetector;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.Repository;
import ru.yoomoney.gradle.plugins.library.dependencies.repositories.aether.AetherRepository;

public class CheckDependenciesTask
extends ConventionTask {
    private final Logger log = LoggerFactory.getLogger(CheckDependenciesTask.class);
    private final CheckDependenciesReporter reporter = new CheckDependenciesReporter();
    private ConflictVersionsChecker conflictVersionsChecker;
    private StaleExclusionsDetector staleExclusionsDetector;
    private FixedDependencies fixedDependencies;
    private VersionConflictResolver conflictResolver;
    @Input
    @Optional
    private List<String> exclusionsRulesSources;
    @Input
    private List<String> includedConfigurations;
    @Input
    private VersionSelectors versionSelectors;

    @TaskAction
    public void check() {
        ExclusionRulesLoader exclusionRulesLoader = this.loadExclusionsRules();
        this.conflictVersionsChecker = new ConflictVersionsChecker(exclusionRulesLoader.getTotalExclusionRules());
        this.staleExclusionsDetector = StaleExclusionsDetector.create(exclusionRulesLoader.getLocalExclusionRules());
        this.fixedDependencies = FixedDependencies.from(this.getProject());
        this.conflictResolver = this.createVersionConflictResolver();
        boolean hasVersionsConflict = false;
        for (Configuration configuration : this.getCheckedConfigurations()) {
            List<ConflictedLibraryInfo> conflictedLibraries = this.calculateConflictedVersionsLibrariesFor(configuration);
            if (conflictedLibraries.isEmpty()) continue;
            this.reporter.reportConflictedLibrariesForConfiguration(configuration, conflictedLibraries);
            hasVersionsConflict = true;
        }
        if (hasVersionsConflict) {
            throw new IllegalStateException(this.reporter.getFormattedReport());
        }
        if (this.staleExclusionsDetector.hasStaleExclusions()) {
            this.reporter.reportStaleExclusions(this.staleExclusionsDetector.getStaleExclusions());
            throw new IllegalStateException(this.reporter.getFormattedReport());
        }
    }

    private VersionConflictResolver createVersionConflictResolver() {
        VersionSelectors versionSelectors = this.getVersionSelectors();
        if (versionSelectors.count() > 0) {
            Repository repository = AetherRepository.create(this.getMavenRepositoryUrls());
            return new RepositoryVersionConflictResolver(repository, this.getVersionSelectors());
        }
        return new DummyVersionConflictResolver();
    }

    private List<String> getMavenRepositoryUrls() {
        Collection repositories = this.getProject().getRepositories().getAsMap().values();
        ArrayList<String> mavenUrls = new ArrayList<String>(repositories.size());
        for (ArtifactRepository repository : repositories) {
            if (repository instanceof MavenArtifactRepository) {
                mavenUrls.add(((MavenArtifactRepository)repository).getUrl().toString());
                continue;
            }
            this.log.warn("Non-maven repository was skipped: {}", (Object)repository.getName());
        }
        return mavenUrls;
    }

    private Iterable<Configuration> getCheckedConfigurations() {
        List<String> included = this.getIncludedConfigurations();
        return this.getProject().getConfigurations().matching(configuration -> included != null && included.contains(configuration.getName()));
    }

    private ExclusionRulesLoader loadExclusionsRules() {
        ExclusionRulesLoader loader = new ExclusionRulesLoader();
        List<String> exclusionsSources = this.getExclusionsRulesSources();
        if (exclusionsSources != null) {
            loader.load(this.getProject(), exclusionsSources);
        }
        return loader;
    }

    private List<ConflictedLibraryInfo> calculateConflictedVersionsLibrariesFor(@Nonnull Configuration configuration) {
        return ConfigurationConflictsAnalyzer.create(this.fixedDependencies, configuration, this.conflictVersionsChecker, this.staleExclusionsDetector, this.conflictResolver).findConflictedLibraries();
    }

    @Nullable
    List<String> getExclusionsRulesSources() {
        return this.exclusionsRulesSources;
    }

    void setExclusionsRulesSources(List<String> exclusionsRulesSources) {
        this.exclusionsRulesSources = new ArrayList<String>(exclusionsRulesSources);
    }

    @Nullable
    List<String> getIncludedConfigurations() {
        return this.includedConfigurations;
    }

    void setIncludedConfigurations(List<String> includedConfigurations) {
        this.includedConfigurations = new ArrayList<String>(includedConfigurations);
    }

    VersionSelectors getVersionSelectors() {
        return this.versionSelectors;
    }

    void setVersionSelector(VersionSelectors versionSelectors) {
        this.versionSelectors = versionSelectors;
    }
}

