/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.artifacts.Configuration;
import ru.yoomoney.gradle.plugins.library.dependencies.analysis.conflicts.ConflictedLibraryInfo;
import ru.yoomoney.gradle.plugins.library.dependencies.exclusions.ExclusionRule;
import ru.yoomoney.gradle.plugins.library.dependencies.reporters.ConflictedLibrariesReporter;
import ru.yoomoney.gradle.plugins.library.dependencies.reporters.StaleExclusionsReporter;

class CheckDependenciesReporter {
    private static final char MESSAGES_INDENT = '\t';
    private static final int BASE_REPORTER_CAPACITY = 1000;
    private final Collection<String> messages = new ArrayList<String>();
    private final ConflictedLibrariesReporter conflictedLibrariesReporter = new ConflictedLibrariesReporter(this.messages);
    private final StaleExclusionsReporter staleExclusionsReporter = new StaleExclusionsReporter(this.messages);

    CheckDependenciesReporter() {
    }

    void reportConflictedLibrariesForConfiguration(Configuration configuration, Iterable<ConflictedLibraryInfo> conflictedLibraries) {
        this.conflictedLibrariesReporter.report(configuration, conflictedLibraries);
    }

    void reportStaleExclusions(Iterable<ExclusionRule> exclusionRules) {
        this.staleExclusionsReporter.report(exclusionRules);
    }

    String getFormattedReport() {
        StringBuilder sb = new StringBuilder(1000);
        this.messages.forEach(message -> sb.append('\t').append((String)message).append('\n'));
        return sb.toString();
    }
}

