/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.library.dependencies;

import io.spring.gradle.dependencymanagement.DependencyManagementPlugin;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import ru.yoomoney.gradle.plugins.library.dependencies.ArtifactVersionResolver;
import ru.yoomoney.gradle.plugins.library.dependencies.CheckDependenciesPluginExtension;
import ru.yoomoney.gradle.plugins.library.dependencies.CheckDependenciesTask;
import ru.yoomoney.gradle.plugins.library.dependencies.checkversion.MajorVersionCheckerExtension;
import ru.yoomoney.gradle.plugins.library.dependencies.checkversion.VersionChecker;
import ru.yoomoney.gradle.plugins.library.dependencies.dsl.VersionSelectors;
import ru.yoomoney.gradle.plugins.library.dependencies.forbiddenartifacts.CheckForbiddenDependenciesTask;
import ru.yoomoney.gradle.plugins.library.dependencies.forbiddenartifacts.ForbiddenDependenciesExtension;
import ru.yoomoney.gradle.plugins.library.dependencies.showdependencies.PrintActualDependenciesByGroupTask;
import ru.yoomoney.gradle.plugins.library.dependencies.showdependencies.PrintAllActualDependenciesTask;
import ru.yoomoney.gradle.plugins.library.dependencies.showdependencies.PrintDependenciesByGroupTask;
import ru.yoomoney.gradle.plugins.library.dependencies.showdependencies.PrintNewDependenciesVersionsTask;
import ru.yoomoney.gradle.plugins.library.dependencies.snapshot.CheckSnapshotsDependenciesTask;

public class CheckDependenciesPlugin
implements Plugin<Project> {
    public static final String CHECK_DEPENDENCIES_TASK_NAME = "checkLibraryDependencies";
    private static final String PRINT_NEW_DEPENDENCIES_TASK_NAME_BY_GROUP = "printNewDependenciesByGroup";
    private static final String PRINT_NEW_DEPENDENCIES_TASK_NAME = "printNewDependencies";
    private static final String PRINT_ACTUAL_DEPENDENCIES_TASK_NAME_BY_GROUP = "printActualDependenciesByGroup";
    private static final String PRINT_ACTUAL_DEPENDENCIES_TASK_NAME = "printActualDependencies";
    private static final String SNAPSHOT_CHECK_TASK_NAME = "checkSnapshotsDependencies";
    private static final String FORBIDDEN_DEPENDENCIES_CHECK_TASK_NAME = "checkForbiddenDependencies";
    private static final String PRINT_DEPENDENCIES_TASK_GROUP = "printDependenciesVersions";
    private static final String VERIFICATION_TASK_GROUP = "verification";
    private static final String CHECK_DEPENDENCIES_TASK_DESCRIPTION = "Checks current used libraries versions on conflict with platform libraries version.";
    private static final String CHECK_DEPENDENCIES_EXTENSION_NAME = "checkDependencies";
    private static final String MAJOR_VERSION_CHECKER_EXTENSION_NAME = "majorVersionChecker";
    private static final String FORBIDDEN_DEPENDENCIES_EXTENSION_NAME = "forbiddenDependenciesChecker";

    public void apply(Project target) {
        target.getPluginManager().apply(DependencyManagementPlugin.class);
        CheckDependenciesPluginExtension checkDependenciesExtension = new CheckDependenciesPluginExtension();
        target.getExtensions().add(CHECK_DEPENDENCIES_EXTENSION_NAME, (Object)checkDependenciesExtension);
        CheckDependenciesTask task = CheckDependenciesPlugin.createCheckDependenciesTask(target);
        target.getTasks().getByName("compileJava").dependsOn(new Object[]{task});
        task.getConventionMapping().map("exclusionsRulesSources", () -> checkDependenciesExtension.exclusionsRulesSources);
        task.getConventionMapping().map("includedConfigurations", () -> checkDependenciesExtension.includedConfigurations);
        task.getConventionMapping().map("versionSelectors", () -> new VersionSelectors(checkDependenciesExtension.versionSelectors));
        MajorVersionCheckerExtension majorVersionCheckerExtension = new MajorVersionCheckerExtension();
        target.getExtensions().add(MAJOR_VERSION_CHECKER_EXTENSION_NAME, (Object)majorVersionCheckerExtension);
        ForbiddenDependenciesExtension forbiddenDependenciesExtension = new ForbiddenDependenciesExtension();
        target.getExtensions().add(FORBIDDEN_DEPENDENCIES_EXTENSION_NAME, (Object)forbiddenDependenciesExtension);
        CheckForbiddenDependenciesTask checkForbiddenDependenciesTask = CheckDependenciesPlugin.createCheckForbiddenDependenciesTask(target);
        task.dependsOn(new Object[]{checkForbiddenDependenciesTask});
        target.afterEvaluate(project -> {
            Set<String> urls = project.getRepositories().stream().filter(repo -> repo instanceof MavenArtifactRepository).map(repo -> ((MavenArtifactRepository)repo).getUrl().toString()).collect(Collectors.toSet());
            ArtifactVersionResolver artifactVersionResolver = new ArtifactVersionResolver(urls);
            if (majorVersionCheckerExtension.enabled) {
                VersionChecker.runCheckVersion(project, majorVersionCheckerExtension, artifactVersionResolver);
            }
            CheckDependenciesPlugin.createPrintNewDependenciesGroupTask(target, checkDependenciesExtension.includeGroupIdForPrintDependencies, artifactVersionResolver);
            CheckDependenciesPlugin.createPrintNewDependenciesTask(target, artifactVersionResolver);
            CheckDependenciesPlugin.createPrintActualDependenciesByGroupTask(target, checkDependenciesExtension.includeGroupIdForPrintDependencies).dependsOn(new Object[]{task});
            CheckDependenciesPlugin.createPrintActualDependenciesTask(target).dependsOn(new Object[]{task});
            CheckDependenciesPlugin.createCheckSnapshotTask(target);
            checkForbiddenDependenciesTask.setForbiddenArtifacts(forbiddenDependenciesExtension.forbiddenArtifacts);
        });
    }

    private static CheckDependenciesTask createCheckDependenciesTask(@Nonnull Project project) {
        CheckDependenciesTask task = (CheckDependenciesTask)project.getTasks().create(CHECK_DEPENDENCIES_TASK_NAME, CheckDependenciesTask.class);
        task.setGroup(VERIFICATION_TASK_GROUP);
        task.setDescription(CHECK_DEPENDENCIES_TASK_DESCRIPTION);
        return task;
    }

    private static void createPrintNewDependenciesGroupTask(@Nonnull Project project, @Nonnull Set<String> includeGroupIdPrefixes, @Nonnull ArtifactVersionResolver artifactVersionResolver) {
        PrintDependenciesByGroupTask task = (PrintDependenciesByGroupTask)project.getTasks().create(PRINT_NEW_DEPENDENCIES_TASK_NAME_BY_GROUP, PrintDependenciesByGroupTask.class);
        task.setGroup(PRINT_DEPENDENCIES_TASK_GROUP);
        task.setDescription("Prints new available versions of dependencies by group list");
        task.setIncludeGroupIdPrefixes(includeGroupIdPrefixes);
        task.setArtifactVersionResolver(artifactVersionResolver);
    }

    private static PrintActualDependenciesByGroupTask createPrintActualDependenciesByGroupTask(@Nonnull Project project, @Nonnull Set<String> includeGroupIdPrefixes) {
        PrintActualDependenciesByGroupTask task = (PrintActualDependenciesByGroupTask)project.getTasks().create(PRINT_ACTUAL_DEPENDENCIES_TASK_NAME_BY_GROUP, PrintActualDependenciesByGroupTask.class);
        task.setGroup(PRINT_DEPENDENCIES_TASK_GROUP);
        task.setDescription("Prints actual versions of dependencies by list");
        task.setIncludeGroupIdPrefixes(includeGroupIdPrefixes);
        return task;
    }

    private static PrintAllActualDependenciesTask createPrintActualDependenciesTask(@Nonnull Project project) {
        PrintAllActualDependenciesTask task = (PrintAllActualDependenciesTask)project.getTasks().create(PRINT_ACTUAL_DEPENDENCIES_TASK_NAME, PrintAllActualDependenciesTask.class);
        task.setGroup(PRINT_DEPENDENCIES_TASK_GROUP);
        task.setDescription("Prints actual versions of all dependencies");
        return task;
    }

    private static void createPrintNewDependenciesTask(@Nonnull Project project, @Nonnull ArtifactVersionResolver artifactVersionResolver) {
        PrintNewDependenciesVersionsTask task = (PrintNewDependenciesVersionsTask)project.getTasks().create(PRINT_NEW_DEPENDENCIES_TASK_NAME, PrintNewDependenciesVersionsTask.class);
        task.setGroup(PRINT_DEPENDENCIES_TASK_GROUP);
        task.setDescription("Prints new available versions of dependencies");
        task.setArtifactVersionResolver(artifactVersionResolver);
    }

    private static void createCheckSnapshotTask(@Nonnull Project project) {
        CheckSnapshotsDependenciesTask task = (CheckSnapshotsDependenciesTask)project.getTasks().create(SNAPSHOT_CHECK_TASK_NAME, CheckSnapshotsDependenciesTask.class);
        task.setGroup(VERIFICATION_TASK_GROUP);
        task.setDescription("Check snapshot dependencies");
    }

    private static CheckForbiddenDependenciesTask createCheckForbiddenDependenciesTask(@Nonnull Project project) {
        CheckForbiddenDependenciesTask task = (CheckForbiddenDependenciesTask)project.getTasks().create(FORBIDDEN_DEPENDENCIES_CHECK_TASK_NAME, CheckForbiddenDependenciesTask.class);
        task.setGroup(VERIFICATION_TASK_GROUP);
        task.setDescription("Check forbidden dependencies");
        return task;
    }
}

