/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.version;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lru/yoomoney/gradle/plugins/release/version/ReleaseInfoStorage;", "", "buildDir", "Ljava/io/File;", "(Ljava/io/File;)V", "loadChangelog", "", "loadVersion", "storeChangelog", "", "changelog", "storeVersion", "version", "Companion", "artifact-release-plugin"})
public final class ReleaseInfoStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File buildDir;
    @NotNull
    private static final String RELEASE_VERSION_PATH = "release/release-version.txt";
    @NotNull
    private static final String RELEASE_CHANGE_LOG_PATH = "release/release-changelog.md";

    public ReleaseInfoStorage(@NotNull File buildDir) {
        Intrinsics.checkNotNullParameter((Object)buildDir, (String)"buildDir");
        this.buildDir = buildDir;
    }

    public final void storeVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        File releaseVersionFile = new File(this.buildDir, RELEASE_VERSION_PATH);
        releaseVersionFile.getParentFile().mkdirs();
        FilesKt.writeText$default((File)releaseVersionFile, (String)version, null, (int)2, null);
    }

    public final void storeChangelog(@NotNull String changelog) {
        Intrinsics.checkNotNullParameter((Object)changelog, (String)"changelog");
        File changelogFile = new File(this.buildDir, RELEASE_CHANGE_LOG_PATH);
        changelogFile.getParentFile().mkdirs();
        FilesKt.writeText$default((File)changelogFile, (String)changelog, null, (int)2, null);
    }

    @Nullable
    public final String loadChangelog() {
        File changelogFile = new File(this.buildDir, RELEASE_CHANGE_LOG_PATH);
        return changelogFile.exists() ? FilesKt.readText$default((File)changelogFile, null, (int)1, null) : (String)null;
    }

    @Nullable
    public final String loadVersion() {
        File releaseVersionFile = new File(this.buildDir, RELEASE_VERSION_PATH);
        return releaseVersionFile.exists() ? FilesKt.readText$default((File)releaseVersionFile, null, (int)1, null) : (String)null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lru/yoomoney/gradle/plugins/release/version/ReleaseInfoStorage$Companion;", "", "()V", "RELEASE_CHANGE_LOG_PATH", "", "RELEASE_VERSION_PATH", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

