/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.version;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.release.version.ReleaseType;
import ru.yoomoney.gradle.plugins.release.version.SemanticVersionEditor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lru/yoomoney/gradle/plugins/release/version/GradlePropertyVersionManager;", "", "gradleProperty", "Ljava/io/File;", "(Ljava/io/File;)V", "getGradleProperty", "()Ljava/io/File;", "appendSnapshotToVersion", "", "getCurrentVersion", "incrementPatchVersion", "removeSnapshotFromVersion", "updateVersion", "", "newVersion", "Companion", "artifact-release-plugin"})
public final class GradlePropertyVersionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File gradleProperty;
    @NotNull
    public static final String DEFAULT_FILE_NAME = "gradle.properties";
    @NotNull
    private static final String SNAPSHOT = "-SNAPSHOT";
    @NotNull
    private static final Regex versionRegex = new Regex("^\\s*version\\s*=\\s*(.+)$");

    public GradlePropertyVersionManager(@NotNull File gradleProperty) {
        Intrinsics.checkNotNullParameter((Object)gradleProperty, (String)"gradleProperty");
        this.gradleProperty = gradleProperty;
    }

    @NotNull
    public final File getGradleProperty() {
        return this.gradleProperty;
    }

    @NotNull
    public final String getCurrentVersion() {
        Object element$iv2;
        block2: {
            Iterable $this$first$iv = FilesKt.readLines$default((File)this.gradleProperty, null, (int)1, null);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                String it = (String)element$iv2;
                boolean bl = false;
                CharSequence charSequence = it;
                Regex regex = versionRegex;
                boolean bl2 = false;
                if (!regex.matches(charSequence)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String versionLine = (String)element$iv2;
        MatchResult matchResult = versionRegex.matchEntire((CharSequence)versionLine);
        Intrinsics.checkNotNull((Object)matchResult);
        String string = (String)matchResult.getGroupValues().get(1);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    @NotNull
    public final String removeSnapshotFromVersion() {
        String currentVersion = this.getCurrentVersion();
        if (StringsKt.endsWith$default((String)currentVersion, (String)SNAPSHOT, (boolean)false, (int)2, null)) {
            String newVersion = StringsKt.replace$default((String)currentVersion, (String)SNAPSHOT, (String)"", (boolean)false, (int)4, null);
            this.updateVersion(newVersion);
            return newVersion;
        }
        return currentVersion;
    }

    @NotNull
    public final String appendSnapshotToVersion() {
        String currentVersion = this.getCurrentVersion();
        if (!StringsKt.endsWith$default((String)currentVersion, (String)SNAPSHOT, (boolean)false, (int)2, null)) {
            String nextVersion = Intrinsics.stringPlus((String)currentVersion, (Object)SNAPSHOT);
            this.updateVersion(nextVersion);
            return nextVersion;
        }
        return currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateVersion(@NotNull String newVersion) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        List lines = FilesKt.readLines$default((File)this.gradleProperty, null, (int)1, null);
        Object object = this.gradleProperty;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        File file = object;
        int n = 8192;
        boolean bl2 = false;
        Object object2 = file;
        boolean bl3 = false;
        Object object3 = object2;
        boolean bl4 = false;
        object3 = new FileOutputStream((File)object3);
        bl4 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl3 = false;
        object = new PrintWriter(object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n));
        boolean bl5 = false;
        bl = false;
        Throwable throwable = null;
        try {
            PrintWriter out = (PrintWriter)object;
            boolean bl6 = false;
            Iterable $this$forEach$iv = lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl7 = false;
                CharSequence charSequence = it;
                Regex regex = versionRegex;
                boolean bl8 = false;
                if (regex.matches(charSequence)) {
                    out.println(Intrinsics.stringPlus((String)"version=", (Object)newVersion));
                    continue;
                }
                out.println(it);
            }
            file = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public final String incrementPatchVersion() {
        String currentVersion = this.getCurrentVersion();
        String versionWithoutSnapshot = StringsKt.endsWith$default((String)currentVersion, (String)SNAPSHOT, (boolean)false, (int)2, null) ? StringsKt.replace$default((String)currentVersion, (String)SNAPSHOT, (String)"", (boolean)false, (int)4, null) : currentVersion;
        SemanticVersionEditor version = new SemanticVersionEditor(versionWithoutSnapshot);
        String nextVersion = version.increment(ReleaseType.PATCH);
        if (StringsKt.endsWith$default((String)currentVersion, (String)SNAPSHOT, (boolean)false, (int)2, null)) {
            nextVersion = Intrinsics.stringPlus((String)nextVersion, (Object)SNAPSHOT);
        }
        this.updateVersion(nextVersion);
        return nextVersion;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lru/yoomoney/gradle/plugins/release/version/GradlePropertyVersionManager$Companion;", "", "()V", "DEFAULT_FILE_NAME", "", "SNAPSHOT", "versionRegex", "Lkotlin/text/Regex;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

