/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.version;

import java.io.File;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.release.changelog.ChangelogManager;
import ru.yoomoney.gradle.plugins.release.git.GitRepo;
import ru.yoomoney.gradle.plugins.release.git.GitRepoFactory;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;
import ru.yoomoney.gradle.plugins.release.version.ReleaseInfoStorage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010\n\u001a\u00020\u0006J\b\u0010\u000b\u001a\u00020\u0006H\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lru/yoomoney/gradle/plugins/release/version/ArtifactVersionProvider;", "", "project", "Lorg/gradle/api/Project;", "isCurrentBranchForRelease", "Ljava/util/function/Predicate;", "", "(Lorg/gradle/api/Project;Ljava/util/function/Predicate;)V", "appendBranchNameAndSnapshot", "currentVersion", "getArtifactVersion", "getGradleProjectVersion", "getVersionFromChangeLog", "Companion", "artifact-release-plugin"})
public final class ArtifactVersionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Predicate<String> isCurrentBranchForRelease;
    @NotNull
    private static final Logger log;

    public ArtifactVersionProvider(@NotNull Project project, @NotNull Predicate<String> isCurrentBranchForRelease) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(isCurrentBranchForRelease, (String)"isCurrentBranchForRelease");
        this.project = project;
        this.isCurrentBranchForRelease = isCurrentBranchForRelease;
    }

    public /* synthetic */ ArtifactVersionProvider(Project project, Predicate predicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            predicate = ArtifactVersionProvider::_init_$lambda-0;
        }
        this(project, predicate);
    }

    @NotNull
    public final String getArtifactVersion() {
        Object[] objectArray = this.project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.buildDir");
        String versionFromStorage = new ReleaseInfoStorage((File)objectArray).loadVersion();
        if (versionFromStorage != null) {
            objectArray = new Object[]{versionFromStorage};
            log.lifecycle("Artifact version from release info storage: version={}", objectArray);
            return versionFromStorage;
        }
        String versionFromChangeLog = this.getVersionFromChangeLog();
        if (versionFromChangeLog != null) {
            Object[] objectArray2 = new Object[]{versionFromChangeLog};
            log.lifecycle("Artifact version from changelog: version={}", objectArray2);
            return versionFromChangeLog;
        }
        String gradleProjectVersion = this.getGradleProjectVersion();
        Object[] objectArray3 = new Object[]{gradleProjectVersion};
        log.lifecycle("Artifact version from gradle project: version={}", objectArray3);
        return gradleProjectVersion;
    }

    private final String getGradleProjectVersion() {
        String string = this.appendBranchNameAndSnapshot(StringsKt.replace$default((String)this.project.getVersion().toString(), (String)"-SNAPSHOT", (String)"", (boolean)false, (int)4, null));
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String appendBranchNameAndSnapshot(String currentVersion) {
        if (currentVersion == null) {
            return null;
        }
        GitSettings dummyGitSettings = new GitSettings("user", "user@yoomoney.ru", null, null);
        GitRepoFactory gitRepoFactory = new GitRepoFactory(dummyGitSettings);
        File file = this.project.getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        GitRepo git = gitRepoFactory.createFromExistingDirectory(file);
        String currentBranchName = git.getCurrentBranchName();
        if (this.isCurrentBranchForRelease.test(currentBranchName)) {
            return currentVersion;
        }
        CharSequence charSequence = currentBranchName;
        Regex regex = new Regex("[^a-zA-Z0-9\\-\\.]+");
        String string = "-";
        boolean bl = false;
        String formatedBranchName = regex.replace(charSequence, string);
        return currentVersion + '-' + formatedBranchName + "-SNAPSHOT";
    }

    private final String getVersionFromChangeLog() {
        File changelogFile = new File(this.project.getRootDir(), "CHANGELOG.md");
        if (changelogFile.exists()) {
            return this.appendBranchNameAndSnapshot(new ChangelogManager(changelogFile).getNextVersion());
        }
        return null;
    }

    private static final boolean _init_$lambda-0(String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        return Intrinsics.areEqual((Object)branchName, (Object)"master") || StringsKt.startsWith$default((String)branchName, (String)"release/", (boolean)false, (int)2, null);
    }

    static {
        Logger logger = Logging.getLogger(ArtifactVersionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ArtifactVersionProvider::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lru/yoomoney/gradle/plugins/release/version/ArtifactVersionProvider$Companion;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "getLog", "()Lorg/gradle/api/logging/Logger;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

