/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010 \u001a\u0004\u0018\u00010\b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00180\"J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lru/yoomoney/gradle/plugins/release/git/GitRepo;", "Ljava/lang/AutoCloseable;", "git", "Lorg/eclipse/jgit/api/Git;", "settings", "Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "(Lorg/eclipse/jgit/api/Git;Lru/yoomoney/gradle/plugins/release/git/GitSettings;)V", "currentBranchName", "", "getCurrentBranchName", "()Ljava/lang/String;", "headCommit", "Lorg/eclipse/jgit/lib/ObjectId;", "getHeadCommit", "()Lorg/eclipse/jgit/lib/ObjectId;", "remoteOriginUrl", "getRemoteOriginUrl", "repository", "Lorg/eclipse/jgit/lib/Repository;", "getRepository", "()Lorg/eclipse/jgit/lib/Repository;", "add", "Lorg/eclipse/jgit/api/AddCommand;", "close", "", "commit", "Lorg/eclipse/jgit/api/CommitCommand;", "listTags", "", "Lorg/eclipse/jgit/lib/Ref;", "log", "Lorg/eclipse/jgit/api/LogCommand;", "push", "command", "Lkotlin/Function1;", "Lorg/eclipse/jgit/api/PushCommand;", "status", "Lorg/eclipse/jgit/api/StatusCommand;", "tag", "Lorg/eclipse/jgit/api/TagCommand;", "Companion", "artifact-release-plugin"})
public final class GitRepo
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Git git;
    @NotNull
    private final GitSettings settings;

    public GitRepo(@NotNull Git git, @NotNull GitSettings settings) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.git = git;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String push(@NotNull Function1<? super PushCommand, Unit> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Objects.requireNonNull(command, "command");
        try {
            Closeable closeable = new ByteArrayOutputStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ByteArrayOutputStream out = (ByteArrayOutputStream)closeable;
                boolean bl3 = false;
                PushCommand pushCommand = this.git.push();
                Intrinsics.checkNotNullExpressionValue((Object)pushCommand, (String)"pushCommand");
                command.invoke((Object)pushCommand);
                Companion.configureTransport((TransportCommand)pushCommand, this.settings);
                pushCommand.setOutputStream((OutputStream)out);
                pushCommand.call();
                String string = out.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
                String resultMessage2 = string;
                String string2 = StringUtils.isEmptyOrNull((String)resultMessage2) || StringsKt.contains$default((CharSequence)resultMessage2, (CharSequence)"Create pull request", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)resultMessage2, (CharSequence)"View pull request", (boolean)false, (int)2, null) ? (String)null : resultMessage2;
                return string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (GitAPIException exc) {
            return exc.getMessage();
        }
        catch (IOException exc) {
            return exc.getMessage();
        }
    }

    @NotNull
    public final ObjectId getHeadCommit() {
        ObjectId objectId = this.git.getRepository().resolve("HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"git.repository.resolve(Constants.HEAD)");
        return objectId;
    }

    @NotNull
    public final List<Ref> listTags() {
        List list = this.git.getRepository().getRefDatabase().getRefsByPrefix("refs/tags/");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"git.repository.refDataba\u2026yPrefix(Constants.R_TAGS)");
        return list;
    }

    @NotNull
    public final String getRemoteOriginUrl() {
        String string = this.git.getRepository().getConfig().getString("remote", "origin", "url");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"git.repository.config\n  \u2026remote\", \"origin\", \"url\")");
        return string;
    }

    @NotNull
    public final Repository getRepository() {
        Repository repository = this.git.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"git.repository");
        return repository;
    }

    @NotNull
    public final TagCommand tag() {
        TagCommand tagCommand = this.git.tag().setTagger(new PersonIdent(this.settings.getUsername(), this.settings.getEmail()));
        Intrinsics.checkNotNullExpressionValue((Object)tagCommand, (String)"git.tag().setTagger(Pers\u2026sername, settings.email))");
        return tagCommand;
    }

    @NotNull
    public final LogCommand log() {
        LogCommand logCommand = this.git.log();
        Intrinsics.checkNotNullExpressionValue((Object)logCommand, (String)"git.log()");
        return logCommand;
    }

    @NotNull
    public final String getCurrentBranchName() {
        String string = this.git.getRepository().getBranch();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"git.repository.branch");
        return string;
    }

    @NotNull
    public final CommitCommand commit() {
        CommitCommand commit = this.git.commit();
        commit.setAuthor(this.settings.getUsername(), this.settings.getEmail());
        Intrinsics.checkNotNullExpressionValue((Object)commit, (String)"commit");
        return commit;
    }

    @NotNull
    public final StatusCommand status() {
        StatusCommand statusCommand = this.git.status();
        Intrinsics.checkNotNullExpressionValue((Object)statusCommand, (String)"git.status()");
        return statusCommand;
    }

    @NotNull
    public final AddCommand add() {
        AddCommand addCommand = this.git.add();
        Intrinsics.checkNotNullExpressionValue((Object)addCommand, (String)"git.add()");
        return addCommand;
    }

    @Override
    public void close() {
        this.git.close();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lru/yoomoney/gradle/plugins/release/git/GitRepo$Companion;", "", "()V", "configureTransport", "", "command", "Lorg/eclipse/jgit/api/TransportCommand;", "settings", "Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void configureTransport(@NotNull TransportCommand<?, ?> command, @NotNull GitSettings settings) {
            Intrinsics.checkNotNullParameter(command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            if (settings.getSshKeyPath() == null) {
                return;
            }
            JschConfigSessionFactory sessionFactory2 = new JschConfigSessionFactory(settings){
                final /* synthetic */ GitSettings $settings;
                {
                    this.$settings = $settings;
                }

                protected void configure(@NotNull OpenSshConfig.Host hc, @NotNull Session session) {
                    Intrinsics.checkNotNullParameter((Object)hc, (String)"hc");
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    session.setConfig("StrictHostKeyChecking", "no");
                }

                @NotNull
                protected JSch getJSch(@NotNull OpenSshConfig.Host hc, @NotNull FS fs) {
                    Intrinsics.checkNotNullParameter((Object)hc, (String)"hc");
                    Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
                    JSch jsch = super.getJSch(hc, fs);
                    jsch.removeAllIdentity();
                    jsch.addIdentity(this.$settings.getSshKeyPath(), this.$settings.getPassphraseSshKey());
                    Intrinsics.checkNotNullExpressionValue((Object)jsch, (String)"jsch");
                    return jsch;
                }
            };
            command.setTransportConfigCallback(arg_0 -> Companion.configureTransport$lambda-0(sessionFactory2, arg_0));
        }

        private static final void configureTransport$lambda-0(JschConfigSessionFactory $sessionFactory, Transport transport) {
            Intrinsics.checkNotNullParameter((Object)$sessionFactory, (String)"$sessionFactory");
            if (transport instanceof SshTransport) {
                ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)$sessionFactory);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

