/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.git;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yoomoney.gradle.plugins.release.git.GitRepo;
import ru.yoomoney.gradle.plugins.release.git.GitRepoFactory;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\nH\u0016J\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0006\u0010\u0017\u001a\u00020\fJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\fJ\u001c\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\u001c\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\b\u0010\u001f\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lru/yoomoney/gradle/plugins/release/git/GitManager;", "Ljava/io/Closeable;", "projectDirectory", "Ljava/io/File;", "gitSettings", "Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "(Ljava/io/File;Lru/yoomoney/gradle/plugins/release/git/GitSettings;)V", "git", "Lru/yoomoney/gradle/plugins/release/git/GitRepo;", "addTag", "", "tag", "", "checkPush", "", "close", "commit", "message", "allowedFilesForCommitRegexStr", "", "getCommitsFromLastTagToHead", "", "Lorg/eclipse/jgit/revwalk/RevCommit;", "getRemoteOriginUrl", "getUncommittedChanges", "", "isTagExists", "version", "newVersionCommit", "nextVersion", "preTagCommit", "push", "Companion", "artifact-release-plugin"})
public final class GitManager
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File projectDirectory;
    @NotNull
    private final GitRepo git;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String NEW_VERSION_RELEASE_PREFIX = "[Gradle Release Plugin] - new version commit";
    @NotNull
    private static final String PRE_TAG_COMMIT_PREFIX = "[Gradle Release Plugin] - pre tag commit";
    @NotNull
    private static final List<String> defaultAllowedFilesToCommit;

    public GitManager(@NotNull File projectDirectory, @NotNull GitSettings gitSettings) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)gitSettings, (String)"gitSettings");
        this.projectDirectory = projectDirectory;
        this.git = new GitRepoFactory(gitSettings).createFromExistingDirectory(this.projectDirectory);
    }

    /*
     * WARNING - void declaration
     */
    private final void commit(String message, List<String> allowedFilesForCommitRegexStr) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object[] objectArray;
        void $this$mapTo$iv$iv2;
        log.lifecycle(Intrinsics.stringPlus((String)"Commit: ", (Object)message));
        Set newFiles = this.git.status().call().getUntracked();
        Iterable $this$map$iv = allowedFilesForCommitRegexStr;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            objectArray = (Object[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterator iterator = it;
            boolean bl2 = false;
            Regex regex = new Regex((String)((Object)iterator));
            collection.add(regex);
        }
        List allowedFilesForCommitRegex = (List)destination$iv$iv;
        AddCommand gitAddCmd = this.git.add();
        Intrinsics.checkNotNullExpressionValue((Object)newFiles, (String)"newFiles");
        Collection $i$f$map22 = newFiles;
        boolean $this$mapTo$iv$iv2 = false;
        if (!$i$f$map22.isEmpty()) {
            $this$forEach$iv = newFiles;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String fileName = (String)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = allowedFilesForCommitRegex;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Regex it = (Regex)element$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
                    if (!it.matches((CharSequence)fileName)) continue;
                    Object[] objectArray2 = new Object[]{fileName};
                    log.lifecycle("Add file for commit: file={}", objectArray2);
                    gitAddCmd.addFilepattern(fileName);
                }
            }
        }
        $this$forEach$iv = defaultAllowedFilesToCommit;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            objectArray = new Object[]{it};
            log.lifecycle("Add file for commit: file={}", objectArray);
            gitAddCmd.addFilepattern(it);
        }
        gitAddCmd.call();
        this.git.commit().setAll(true).setMessage(message).call();
    }

    private final void addTag(String tag) {
        log.lifecycle(Intrinsics.stringPlus((String)"Tag : ", (Object)tag));
        this.git.tag().setName(tag).call();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isTagExists(@NotNull String version) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        List list = this.git.getRepository().getRefDatabase().getRefsByPrefix("refs/tags/");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"git.repository.refDataba\u2026yPrefix(Constants.R_TAGS)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ref it = (Ref)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Intrinsics.stringPlus((String)"refs/tags/", (Object)version))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tag = (List)destination$iv$iv;
        return !tag.isEmpty();
    }

    @Nullable
    public final String push() {
        return this.git.push((Function1<? super PushCommand, Unit>)((Function1)new Function1<PushCommand, Unit>(this){
            final /* synthetic */ GitManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PushCommand pushCommand) {
                Intrinsics.checkNotNullParameter((Object)pushCommand, (String)"pushCommand");
                pushCommand.setPushTags().add(GitManager.access$getGit$p(this.this$0).getRepository().getFullBranch()).setRemote("origin");
            }
        }));
    }

    public final boolean checkPush() {
        this.git.commit().setMessage("[Gradle Release Plugin] Check push").setAllowEmpty(true).call();
        String resultMessage2 = this.git.push((Function1<? super PushCommand, Unit>)((Function1)new Function1<PushCommand, Unit>(this){
            final /* synthetic */ GitManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PushCommand pushCommand) {
                Intrinsics.checkNotNullParameter((Object)pushCommand, (String)"pushCommand");
                pushCommand.add(GitManager.access$getGit$p(this.this$0).getRepository().getFullBranch()).setRemote("origin");
            }
        }));
        return resultMessage2 == null;
    }

    @NotNull
    public final Set<String> getUncommittedChanges() {
        Status status = this.git.status().call();
        Set set = status.getUncommittedChanges();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"status.uncommittedChanges");
        return set;
    }

    public final void preTagCommit(@NotNull String version, @NotNull List<String> allowedFilesForCommitRegexStr) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(allowedFilesForCommitRegexStr, (String)"allowedFilesForCommitRegexStr");
        this.commit("[Gradle Release Plugin] - pre tag commit: '" + version + "'.", allowedFilesForCommitRegexStr);
        this.addTag(version);
    }

    public final void newVersionCommit(@NotNull String nextVersion, @NotNull List<String> allowedFilesForCommitRegexStr) {
        Intrinsics.checkNotNullParameter((Object)nextVersion, (String)"nextVersion");
        Intrinsics.checkNotNullParameter(allowedFilesForCommitRegexStr, (String)"allowedFilesForCommitRegexStr");
        this.commit("[Gradle Release Plugin] - new version commit: '" + nextVersion + "'.", allowedFilesForCommitRegexStr);
    }

    @NotNull
    public final String getRemoteOriginUrl() {
        return this.git.getRemoteOriginUrl();
    }

    @NotNull
    public final Iterable<RevCommit> getCommitsFromLastTagToHead() {
        Iterable iterable;
        List<Ref> tags = this.git.listTags();
        if (tags.isEmpty()) {
            Iterable iterable2 = this.git.log().add((AnyObjectId)this.git.getHeadCommit()).call();
            Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"{\n            git.log().\u2026dCommit).call()\n        }");
            iterable = iterable2;
        } else {
            RevCommit lastTaggedCommit = this.git.getRepository().parseCommit((AnyObjectId)((Ref)CollectionsKt.last(tags)).getObjectId());
            Iterable iterable3 = this.git.log().addRange((AnyObjectId)lastTaggedCommit, (AnyObjectId)this.git.getHeadCommit()).call();
            Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"{\n            val lastTa\u2026dCommit).call()\n        }");
            iterable = iterable3;
        }
        return iterable;
    }

    @Override
    public void close() {
        this.git.close();
    }

    public static final /* synthetic */ GitRepo access$getGit$p(GitManager $this) {
        return $this.git;
    }

    static {
        Object[] objectArray = Logging.getLogger(GitManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getLogger(GitManager::class.java)");
        log = objectArray;
        objectArray = new String[]{"CHANGELOG.md", "gradle.properties"};
        defaultAllowedFilesToCommit = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lru/yoomoney/gradle/plugins/release/git/GitManager$Companion;", "", "()V", "NEW_VERSION_RELEASE_PREFIX", "", "PRE_TAG_COMMIT_PREFIX", "defaultAllowedFilesToCommit", "", "log", "Lorg/gradle/api/logging/Logger;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

