/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.changelog;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import ru.yoomoney.gradle.plugins.release.PullRequestInfoProvider;
import ru.yoomoney.gradle.plugins.release.PullRequestLinkSettings;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketClient;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketConnectionSettings;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequestCommit;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequestLink;
import ru.yoomoney.gradle.plugins.release.bitbucket.PullRequestState;
import ru.yoomoney.gradle.plugins.release.git.GitManager;
import ru.yoomoney.gradle.plugins.release.github.GitHubClient;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\r\u001a\u0004\u0018\u00010\fJ\b\u0010\u000e\u001a\u0004\u0018\u00010\fJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/PullRequestLinkProvider;", "", "gitManager", "Lru/yoomoney/gradle/plugins/release/git/GitManager;", "pullRequestLinkSettings", "Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;", "(Lru/yoomoney/gradle/plugins/release/git/GitManager;Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;)V", "gitHubClient", "Lru/yoomoney/gradle/plugins/release/github/GitHubClient;", "settings", "(Lru/yoomoney/gradle/plugins/release/git/GitManager;Lru/yoomoney/gradle/plugins/release/github/GitHubClient;Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;)V", "getReleasePullRequestLink", "", "getReleasePullRequestLinkFromBitbucket", "getReleasePullRequestLinkFromGitHub", "isPullRequestValid", "", "commitsId", "", "parseArtifactLocation", "Lru/yoomoney/gradle/plugins/release/changelog/PullRequestLinkProvider$ArtifactLocation;", "path", "parseHttpArtifactLocation", "url", "Ljava/net/URI;", "parseSshArtifactLocation", "ArtifactLocation", "Companion", "artifact-release-plugin"})
public final class PullRequestLinkProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitManager gitManager;
    @NotNull
    private final GitHubClient gitHubClient;
    @NotNull
    private final PullRequestLinkSettings settings;
    @NotNull
    private static final Logger log;

    public PullRequestLinkProvider(@NotNull GitManager gitManager, @NotNull GitHubClient gitHubClient, @NotNull PullRequestLinkSettings settings) {
        Intrinsics.checkNotNullParameter((Object)gitManager, (String)"gitManager");
        Intrinsics.checkNotNullParameter((Object)gitHubClient, (String)"gitHubClient");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.gitManager = gitManager;
        this.gitHubClient = gitHubClient;
        this.settings = settings;
    }

    public PullRequestLinkProvider(@NotNull GitManager gitManager, @NotNull PullRequestLinkSettings pullRequestLinkSettings) {
        Intrinsics.checkNotNullParameter((Object)gitManager, (String)"gitManager");
        Intrinsics.checkNotNullParameter((Object)pullRequestLinkSettings, (String)"pullRequestLinkSettings");
        this(gitManager, new GitHubClient(pullRequestLinkSettings), pullRequestLinkSettings);
    }

    @Nullable
    public final String getReleasePullRequestLink() {
        PullRequestInfoProvider pullRequestInfoProvider = this.settings.getPullRequestInfoProvider();
        int n = WhenMappings.$EnumSwitchMapping$0[pullRequestInfoProvider.ordinal()];
        switch (n) {
            case 1: {
                return this.getReleasePullRequestLinkFromGitHub();
            }
            case 2: {
                return this.getReleasePullRequestLinkFromBitbucket();
            }
        }
        return null;
    }

    @Nullable
    public final String getReleasePullRequestLinkFromBitbucket() {
        try {
            ArtifactLocation artifactLocation = this.parseArtifactLocation(this.gitManager.getRemoteOriginUrl());
            String string = this.settings.getBitbucketApiToken();
            if (string == null) {
                throw new IllegalArgumentException("bitbucketApiToken is absent");
            }
            BitbucketClient bitbucketClient = new BitbucketClient(BitbucketConnectionSettings.Companion.builder().withUri(URI.create(artifactLocation.getHost())).withApiToken(string).build());
            return bitbucketClient.getLatestPullRequestLink(artifactLocation.getProject(), artifactLocation.getRepository(), PullRequestState.MERGED).filter(arg_0 -> PullRequestLinkProvider.getReleasePullRequestLinkFromBitbucket$lambda-1(bitbucketClient, artifactLocation, this, arg_0)).map(PullRequestLinkProvider::getReleasePullRequestLinkFromBitbucket$lambda-2).orElse(null);
        }
        catch (Exception e) {
            log.warn("can't getPullRequestLink", (Throwable)e);
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getReleasePullRequestLinkFromGitHub() {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ArtifactLocation location = this.parseArtifactLocation(this.gitManager.getRemoteOriginUrl());
            GHPullRequest gHPullRequest = this.gitHubClient.getLatestPullRequest(location.getProject(), location.getRepository(), GHIssueState.CLOSED);
            if (gHPullRequest == null) {
                return null;
            }
            GHPullRequest latestPullRequest = gHPullRequest;
            Iterable iterable = latestPullRequest.listCommits().toList();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"latestPullRequest\n      \u2026  .listCommits().toList()");
            iterable = iterable;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GHPullRequestCommitDetail gHPullRequestCommitDetail = (GHPullRequestCommitDetail)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getSha();
                collection.add(string);
            }
            List githubPullRequestCommitMessages = (List)destination$iv$iv;
            if (!this.isPullRequestValid(githubPullRequestCommitMessages)) {
                return null;
            }
            return latestPullRequest.getHtmlUrl().toString();
        }
        catch (Exception e) {
            log.warn("can't getPullRequestLink", (Throwable)e);
            String string = null;
            return string;
        }
    }

    private final ArtifactLocation parseArtifactLocation(String path) {
        ArtifactLocation artifactLocation = null;
        artifactLocation = StringsKt.startsWith$default((String)path, (String)"http", (boolean)false, (int)2, null) ? this.parseHttpArtifactLocation(new URI(path)) : this.parseSshArtifactLocation(path);
        log.info("Got artifact location for pull-request's link: artifactLocation{}", (Object)artifactLocation);
        return artifactLocation;
    }

    private final ArtifactLocation parseHttpArtifactLocation(URI url) {
        String[] stringArray = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"url.path");
        CharSequence charSequence = (CharSequence)stringArray;
        stringArray = new String[]{"/"};
        List pathFragments = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string = url.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.scheme");
        String scheme = StringsKt.startsWith$default((String)string, (String)"http", (boolean)false, (int)2, null) ? Intrinsics.stringPlus((String)url.getScheme(), (Object)"://") : "";
        return new ArtifactLocation(scheme + url.getHost() + ':' + url.getPort(), (String)pathFragments.get(1), StringsKt.removeSuffix((String)((String)pathFragments.get(2)), (CharSequence)".git"));
    }

    private final ArtifactLocation parseSshArtifactLocation(String path) {
        String[] stringArray = new String[]{"git@"};
        String pathWithousScheme = (String)StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        String[] stringArray2 = new String[]{"/", ":"};
        List pathFragments = StringsKt.split$default((CharSequence)pathWithousScheme, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        return new ArtifactLocation(Intrinsics.stringPlus((String)"https://", pathFragments.get(0)), (String)pathFragments.get(1), StringsKt.removeSuffix((String)((String)pathFragments.get(2)), (CharSequence)".git"));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPullRequestValid(List<String> commitsId) {
        boolean bl;
        String string;
        String it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.gitManager.getCommitsFromLastTagToHead();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RevCommit revCommit = (RevCommit)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            string = it.toObjectId().name();
            collection.add(string);
        }
        List gitCommitMessagesFromLastTag = (List)destination$iv$iv;
        if (gitCommitMessagesFromLastTag.containsAll((Collection)commitsId)) {
            bl = true;
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            $this$map$iv = commitsId;
            string = "unknown pull request commits: messages={}";
            collection = log;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!(!gitCommitMessagesFromLastTag.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            collection.warn(string, list);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean getReleasePullRequestLinkFromBitbucket$lambda-1(BitbucketClient $bitbucketClient, ArtifactLocation $artifactLocation, PullRequestLinkProvider this$0, BitbucketPullRequestLink it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$bitbucketClient, (String)"$bitbucketClient");
        Intrinsics.checkNotNullParameter((Object)$artifactLocation, (String)"$artifactLocation");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = $artifactLocation.getProject();
        String string2 = $artifactLocation.getRepository();
        Long l = it.getPullRequestId();
        Intrinsics.checkNotNull((Object)l);
        Iterable iterable = $bitbucketClient.getPullRequestCommits(string, string2, l);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string3;
            void it2;
            BitbucketPullRequestCommit bitbucketPullRequestCommit = (BitbucketPullRequestCommit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2.getId());
            collection.add(string3);
        }
        List bitbucketPullRequestCommitMessages = (List)destination$iv$iv;
        return this$0.isPullRequestValid(bitbucketPullRequestCommitMessages);
    }

    private static final String getReleasePullRequestLinkFromBitbucket$lambda-2(BitbucketPullRequestLink it) {
        return it.getLink();
    }

    static {
        Logger logger = Logging.getLogger(PullRequestInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PullRequestInfoProvider::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/PullRequestLinkProvider$Companion;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/PullRequestLinkProvider$ArtifactLocation;", "", "host", "", "project", "repository", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getProject", "getRepository", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "artifact-release-plugin"})
    private static final class ArtifactLocation {
        @NotNull
        private final String host;
        @NotNull
        private final String project;
        @NotNull
        private final String repository;

        public ArtifactLocation(@NotNull String host, @NotNull String project, @NotNull String repository) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            this.host = host;
            this.project = project;
            this.repository = repository;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @NotNull
        public final String getProject() {
            return this.project;
        }

        @NotNull
        public final String getRepository() {
            return this.repository;
        }

        @NotNull
        public final String component1() {
            return this.host;
        }

        @NotNull
        public final String component2() {
            return this.project;
        }

        @NotNull
        public final String component3() {
            return this.repository;
        }

        @NotNull
        public final ArtifactLocation copy(@NotNull String host, @NotNull String project, @NotNull String repository) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            return new ArtifactLocation(host, project, repository);
        }

        public static /* synthetic */ ArtifactLocation copy$default(ArtifactLocation artifactLocation, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = artifactLocation.host;
            }
            if ((n & 2) != 0) {
                string2 = artifactLocation.project;
            }
            if ((n & 4) != 0) {
                string3 = artifactLocation.repository;
            }
            return artifactLocation.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ArtifactLocation(host=" + this.host + ", project=" + this.project + ", repository=" + this.repository + ')';
        }

        public int hashCode() {
            int result = this.host.hashCode();
            result = result * 31 + this.project.hashCode();
            result = result * 31 + this.repository.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArtifactLocation)) {
                return false;
            }
            ArtifactLocation artifactLocation = (ArtifactLocation)other;
            if (!Intrinsics.areEqual((Object)this.host, (Object)artifactLocation.host)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.project, (Object)artifactLocation.project)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.repository, (Object)artifactLocation.repository);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PullRequestInfoProvider.values().length];
            nArray[PullRequestInfoProvider.GIT_HUB.ordinal()] = 1;
            nArray[PullRequestInfoProvider.BITBUCKET.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

