/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.changelog;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yoomoney.gradle.plugins.release.version.ReleaseType;
import ru.yoomoney.gradle.plugins.release.version.SemanticVersionEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/ChangelogManager;", "", "changeLog", "Ljava/io/File;", "(Ljava/io/File;)V", "appendNextVersionDescriptionMarkers", "", "getCurrentDate", "", "getLastVersion", "getNexVersionDescription", "getNextVersion", "getNextVersionType", "Lru/yoomoney/gradle/plugins/release/version/ReleaseType;", "hasBreakingChangesMarker", "", "hasNextVersionInfo", "isMajorVersion", "isNextVersionFirst", "readContent", "updateToNextVersion", "Lru/yoomoney/gradle/plugins/release/changelog/ChangelogManager$ChangelogReleaseInfo;", "githubPullRequestLink", "ChangelogReleaseInfo", "Companion", "artifact-release-plugin"})
public final class ChangelogManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File changeLog;
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String NEXT_VERSION_TYPE_MARKER = "### NEXT_VERSION_TYPE=MAJOR|MINOR|PATCH";
    @NotNull
    public static final String DESCRIPTION_BEGIN_MARKER = "### NEXT_VERSION_DESCRIPTION_BEGIN";
    @NotNull
    public static final String DESCRIPTION_END_MARKER = "### NEXT_VERSION_DESCRIPTION_END";
    @NotNull
    public static final String DEFAULT_FILE_NAME = "CHANGELOG.md";
    @NotNull
    public static final String BREAKING_CHANGES_MARKER = "breaking changes";
    @NotNull
    private static final Regex previousVersionRegexp;
    @NotNull
    private static final Regex nextVersionTypeRegexp;

    public ChangelogManager(@NotNull File changeLog) {
        Intrinsics.checkNotNullParameter((Object)changeLog, (String)"changeLog");
        this.changeLog = changeLog;
    }

    public final boolean isMajorVersion() {
        return this.getNextVersionType() == ReleaseType.MAJOR;
    }

    public final boolean isNextVersionFirst() {
        return StringsKt.equals$default((String)this.getNextVersion(), (String)"1.0.0", (boolean)false, (int)2, null);
    }

    public final boolean hasBreakingChangesMarker() {
        String description = this.getNexVersionDescription();
        CharSequence charSequence = description;
        boolean bl = false;
        return charSequence.length() > 0 && StringsKt.contains$default((CharSequence)description, (CharSequence)BREAKING_CHANGES_MARKER, (boolean)false, (int)2, null);
    }

    public final boolean hasNextVersionInfo() {
        CharSequence charSequence = this.getNexVersionDescription();
        boolean bl = false;
        return charSequence.length() > 0 && this.getNextVersionType() != null;
    }

    private final ReleaseType getNextVersionType() {
        for (String line : FilesKt.readLines$default((File)this.changeLog, null, (int)1, null)) {
            MatchResult matchResult = nextVersionTypeRegexp.matchEntire((CharSequence)line);
            if (matchResult == null) continue;
            return ReleaseType.valueOf((String)matchResult.getGroupValues().get(1));
        }
        return null;
    }

    private final String getLastVersion() {
        for (String line : FilesKt.readLines$default((File)this.changeLog, null, (int)1, null)) {
            MatchResult matchEntire = previousVersionRegexp.matchEntire((CharSequence)line);
            if (matchEntire == null) continue;
            return (String)matchEntire.getGroupValues().get(1);
        }
        return null;
    }

    @Nullable
    public final String getNextVersion() {
        ReleaseType releaseType = this.getNextVersionType();
        if (releaseType == null) {
            return null;
        }
        ReleaseType nextVersionType = releaseType;
        String lastVersion = this.getLastVersion();
        return new SemanticVersionEditor(lastVersion).increment(nextVersionType);
    }

    @NotNull
    public final ChangelogReleaseInfo updateToNextVersion(@Nullable String githubPullRequestLink) {
        String nextVersionDescription = this.getNexVersionDescription();
        ReleaseType nextVersionType = this.getNextVersionType();
        CharSequence charSequence = nextVersionDescription;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw new GradleException("Changelog doesn't have new version description, skip update to next version");
        }
        if (nextVersionType == null) {
            throw new GradleException("Changelog doesn't have new version type, skip update to next version");
        }
        String lastVersion = this.getLastVersion();
        String nextVersion = new SemanticVersionEditor(lastVersion).increment(nextVersionType);
        Object[] objectArray = new Object[]{lastVersion, nextVersion, nextVersionType, nextVersionDescription};
        log.lifecycle("Changelog release version info :lastVersion={}, nextVersion={}, type={} description=\n{}", objectArray);
        String fullChangeLog = FilesKt.readLines$default((File)this.changeLog, null, (int)1, null).stream().filter(ChangelogManager::updateToNextVersion$lambda-0).collect(Collectors.joining("\n"));
        Intrinsics.checkNotNullExpressionValue((Object)fullChangeLog, (String)"fullChangeLog");
        int indexOfBeginMarker = StringsKt.indexOf$default((CharSequence)fullChangeLog, (String)DESCRIPTION_BEGIN_MARKER, (int)0, (boolean)false, (int)6, null);
        int indexOfEndMarker = StringsKt.indexOf$default((CharSequence)fullChangeLog, (String)DESCRIPTION_END_MARKER, (int)0, (boolean)false, (int)6, null);
        String string = fullChangeLog;
        int n = 0;
        int n2 = 0;
        String string2 = string.substring(n, indexOfBeginMarker);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String header = string2;
        String string3 = fullChangeLog;
        n2 = indexOfEndMarker + DESCRIPTION_END_MARKER.length();
        boolean bl2 = false;
        String string4 = string3.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String footer = string4;
        PrintWriter writer = new PrintWriter(this.changeLog);
        CharSequence charSequence2 = header;
        bl2 = false;
        if (charSequence2.length() > 0) {
            writer.println(header);
        }
        writer.println("## [" + nextVersion + "](" + (String)((charSequence2 = githubPullRequestLink) == null ? "" : charSequence2) + ") (" + this.getCurrentDate() + ')');
        writer.println();
        writer.println(nextVersionDescription);
        writer.print(footer);
        writer.close();
        return new ChangelogReleaseInfo(nextVersion, nextVersionDescription);
    }

    private final String getCurrentDate() {
        String string = LocalDate.now().format(DateTimeFormatter.ofPattern("dd-MM-yyyy"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"now().format(DateTimeFor\u2026.ofPattern(\"dd-MM-yyyy\"))");
        return string;
    }

    public final void appendNextVersionDescriptionMarkers() {
        String newChangeLogContent = Intrinsics.stringPlus((String)"### NEXT_VERSION_TYPE=MAJOR|MINOR|PATCH\n### NEXT_VERSION_DESCRIPTION_BEGIN\n### NEXT_VERSION_DESCRIPTION_END\n", (Object)this.readContent());
        Path path = this.changeLog.toPath();
        String string = newChangeLogContent;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private final String readContent() {
        return CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)this.changeLog, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getNexVersionDescription() {
        StringBuilder result = new StringBuilder();
        boolean afterBegin = false;
        Object object = FilesKt.readLines$default((File)this.changeLog, null, (int)1, null).iterator();
        while (object.hasNext()) {
            String line;
            String string = line = (String)object.next();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String trimmedLine = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (!afterBegin && Intrinsics.areEqual((Object)trimmedLine, (Object)DESCRIPTION_BEGIN_MARKER)) {
                afterBegin = true;
                continue;
            }
            if (afterBegin && Intrinsics.areEqual((Object)trimmedLine, (Object)DESCRIPTION_END_MARKER)) {
                afterBegin = false;
                break;
            }
            if (!afterBegin) continue;
            result.append(trimmedLine).append('\n');
        }
        if (afterBegin) {
            return "";
        }
        object = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.toString()");
        boolean bl = false;
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
    }

    private static final boolean updateToNextVersion$lambda-0(String it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String string = it;
        boolean bl = false;
        return !nextVersionTypeRegexp.matches((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString());
    }

    static {
        Logger logger = Logging.getLogger(ChangelogManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ChangelogManager::class.java)");
        log = logger;
        previousVersionRegexp = new Regex("^## \\[(\\d+\\.\\d+\\.\\d+)\\]\\(.*\\)\\s+\\(\\d+-\\d+-\\d+\\)$");
        nextVersionTypeRegexp = new Regex("^### NEXT_VERSION_TYPE=(MAJOR|MINOR|PATCH)$");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/ChangelogManager$Companion;", "", "()V", "BREAKING_CHANGES_MARKER", "", "DEFAULT_FILE_NAME", "DESCRIPTION_BEGIN_MARKER", "DESCRIPTION_END_MARKER", "NEXT_VERSION_TYPE_MARKER", "log", "Lorg/gradle/api/logging/Logger;", "nextVersionTypeRegexp", "Lkotlin/text/Regex;", "previousVersionRegexp", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/ChangelogManager$ChangelogReleaseInfo;", "", "releaseVersion", "", "releaseDescriptionMd", "(Ljava/lang/String;Ljava/lang/String;)V", "getReleaseDescriptionMd", "()Ljava/lang/String;", "getReleaseVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "artifact-release-plugin"})
    public static final class ChangelogReleaseInfo {
        @NotNull
        private final String releaseVersion;
        @NotNull
        private final String releaseDescriptionMd;

        public ChangelogReleaseInfo(@NotNull String releaseVersion, @NotNull String releaseDescriptionMd) {
            Intrinsics.checkNotNullParameter((Object)releaseVersion, (String)"releaseVersion");
            Intrinsics.checkNotNullParameter((Object)releaseDescriptionMd, (String)"releaseDescriptionMd");
            this.releaseVersion = releaseVersion;
            this.releaseDescriptionMd = releaseDescriptionMd;
        }

        @NotNull
        public final String getReleaseVersion() {
            return this.releaseVersion;
        }

        @NotNull
        public final String getReleaseDescriptionMd() {
            return this.releaseDescriptionMd;
        }

        @NotNull
        public final String component1() {
            return this.releaseVersion;
        }

        @NotNull
        public final String component2() {
            return this.releaseDescriptionMd;
        }

        @NotNull
        public final ChangelogReleaseInfo copy(@NotNull String releaseVersion, @NotNull String releaseDescriptionMd) {
            Intrinsics.checkNotNullParameter((Object)releaseVersion, (String)"releaseVersion");
            Intrinsics.checkNotNullParameter((Object)releaseDescriptionMd, (String)"releaseDescriptionMd");
            return new ChangelogReleaseInfo(releaseVersion, releaseDescriptionMd);
        }

        public static /* synthetic */ ChangelogReleaseInfo copy$default(ChangelogReleaseInfo changelogReleaseInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = changelogReleaseInfo.releaseVersion;
            }
            if ((n & 2) != 0) {
                string2 = changelogReleaseInfo.releaseDescriptionMd;
            }
            return changelogReleaseInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ChangelogReleaseInfo(releaseVersion=" + this.releaseVersion + ", releaseDescriptionMd=" + this.releaseDescriptionMd + ')';
        }

        public int hashCode() {
            int result = this.releaseVersion.hashCode();
            result = result * 31 + this.releaseDescriptionMd.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChangelogReleaseInfo)) {
                return false;
            }
            ChangelogReleaseInfo changelogReleaseInfo = (ChangelogReleaseInfo)other;
            if (!Intrinsics.areEqual((Object)this.releaseVersion, (Object)changelogReleaseInfo.releaseVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.releaseDescriptionMd, (Object)changelogReleaseInfo.releaseDescriptionMd);
        }
    }
}

