/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.bitbucket;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketConnectionSettings;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequest;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequestCommit;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequestCommitsResponse;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequestInfoResponse;
import ru.yoomoney.gradle.plugins.release.bitbucket.BitbucketPullRequestLink;
import ru.yoomoney.gradle.plugins.release.bitbucket.PullRequestState;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/yoomoney/gradle/plugins/release/bitbucket/BitbucketClient;", "", "settings", "Lru/yoomoney/gradle/plugins/release/bitbucket/BitbucketConnectionSettings;", "(Lru/yoomoney/gradle/plugins/release/bitbucket/BitbucketConnectionSettings;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getLatestPullRequestLink", "Ljava/util/Optional;", "Lru/yoomoney/gradle/plugins/release/bitbucket/BitbucketPullRequestLink;", "project", "", "repository", "state", "Lru/yoomoney/gradle/plugins/release/bitbucket/PullRequestState;", "getPullRequestCommits", "", "Lru/yoomoney/gradle/plugins/release/bitbucket/BitbucketPullRequestCommit;", "pullRequestId", "", "Companion", "artifact-release-plugin"})
public final class BitbucketClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitbucketConnectionSettings settings;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(BitbucketClient.class);
    @NotNull
    private static final String ANY_REF = "ANY_REF_MATCHER_ID";
    @NotNull
    public static final String BITBUCKET_TO_JENKINS_HOOK_KEY = "com.nerdwin15.stash-stash-webhook-jenkins:jenkinsPostReceiveHook";

    public BitbucketClient(@NotNull BitbucketConnectionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"ObjectMapper().configure\u2026NKNOWN_PROPERTIES, false)");
        this.objectMapper = objectMapper;
    }

    @Nonnull
    @NotNull
    public final Optional<BitbucketPullRequestLink> getLatestPullRequestLink(@Nonnull @Nullable String project, @Nonnull @Nullable String repository, @Nonnull @NotNull PullRequestState state) {
        Optional<BitbucketPullRequestLink> optional;
        Optional<BitbucketPullRequestLink> e2;
        HttpResponse httpResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        log.info("getLatestMergedPullRequestLink: project={}, repository={}", (Object)project, (Object)repository);
        HttpResponse response = null;
        try {
            String urlPattern = "%s%s/rest/api/1.0/projects/%s/repos/%s/pull-requests?state=%s&order=NEWEST";
            URI uRI = this.settings.getUri();
            Intrinsics.checkNotNull((Object)uRI);
            String host = uRI.toASCIIString();
            Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
            String schema = StringsKt.startsWith$default((String)host, (String)"http", (boolean)false, (int)2, null) ? "" : "https://";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = new Object[]{schema, host, project, repository, state.getCode()};
            boolean bl = false;
            String string = String.format(urlPattern, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            httpResponse = Unirest.get((String)string).header("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)this.settings.getApiToken())).asString();
            Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"{\n            val urlPat\u2026    .asString()\n        }");
        }
        catch (UnirestException e2) {
            throw new RuntimeException("can't getLatestMergedPullRequestLink", e2);
        }
        response = httpResponse;
        log.debug("getLatestMergedPullRequestLink: response={}", (Object)response);
        if (response.getStatus() != 200 || response.getBody() == null) {
            throw new RuntimeException("can't getLatestMergedPullRequestLink: code=" + response.getStatus() + ", body=" + response.getBody());
        }
        BitbucketPullRequestInfoResponse pullRequestInfoResponse = null;
        try {
            e2 = this.objectMapper.readValue((String)response.getBody(), BitbucketPullRequestInfoResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)e2, (String)"objectMapper\n           \u2026InfoResponse::class.java)");
            pullRequestInfoResponse = (BitbucketPullRequestInfoResponse)((Object)e2);
        }
        catch (IOException e3) {
            log.info("can't parse response: response={}", response.getBody(), (Object)e3);
            optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
            return optional;
        }
        if (pullRequestInfoResponse.getPullRequests().isEmpty()) {
            log.info("List of pull-request is empty: response={}", response.getBody());
            e2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"empty()");
            return e2;
        }
        BitbucketPullRequest bitbucketPullRequest = pullRequestInfoResponse.getPullRequests().get(0);
        log.info("getLatestMergedPullRequestLink: pullRequest={}", (Object)bitbucketPullRequest);
        BitbucketPullRequestLink.Builder builder = BitbucketPullRequestLink.Companion.builder();
        BitbucketPullRequest bitbucketPullRequest2 = bitbucketPullRequest;
        Intrinsics.checkNotNull((Object)bitbucketPullRequest2);
        optional = Optional.of(builder.withPullRequestId(bitbucketPullRequest2.getPullRequestId()).withLink(bitbucketPullRequest.getLink()).build());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(BitbucketPullRequestL\u2026                .build())");
        return optional;
    }

    @Nonnull
    @NotNull
    public final List<BitbucketPullRequestCommit> getPullRequestCommits(@Nonnull @Nullable String project, @Nonnull @Nullable String repository, long pullRequestId) {
        HttpResponse httpResponse;
        log.info("getPullRequestCommits: project={}, repository={}", (Object)project, (Object)repository);
        HttpResponse response = null;
        try {
            String urlPattern = "%s%s/rest/api/1.0/projects/%s/repos/%s/pull-requests/%s/commits";
            URI uRI = this.settings.getUri();
            Intrinsics.checkNotNull((Object)uRI);
            String host = uRI.toASCIIString();
            Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
            String schema = StringsKt.startsWith$default((String)host, (String)"http", (boolean)false, (int)2, null) ? "" : "https://";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = new Object[]{schema, host, project, repository, pullRequestId};
            boolean bl = false;
            String string = String.format(urlPattern, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            httpResponse = Unirest.get((String)string).header("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)this.settings.getApiToken())).asString();
            Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"{\n            val urlPat\u2026    .asString()\n        }");
        }
        catch (UnirestException e) {
            throw new RuntimeException("can't getLatestMergedPullRequestLink", e);
        }
        response = httpResponse;
        log.debug("getPullRequestCommits: response={}", (Object)response);
        if (response.getStatus() != 200 || response.getBody() == null) {
            throw new RuntimeException("can't getPullRequestCommits: code=" + response.getStatus() + ", body=" + response.getBody());
        }
        BitbucketPullRequestCommitsResponse pullRequestCommitsResponse = null;
        try {
            Object e = this.objectMapper.readValue((String)response.getBody(), BitbucketPullRequestCommitsResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"objectMapper\n           \u2026mitsResponse::class.java)");
            pullRequestCommitsResponse = (BitbucketPullRequestCommitsResponse)e;
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{response.getStatus(), response.getBody()};
            throw new RuntimeException(String.format("can't getPullRequestCommits: code=%s, body=%s", objectArray), e);
        }
        return pullRequestCommitsResponse.getPullRequestsCommits();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lru/yoomoney/gradle/plugins/release/bitbucket/BitbucketClient$Companion;", "", "()V", "ANY_REF", "", "BITBUCKET_TO_JENKINS_HOOK_KEY", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

