/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.release.CheckPreReleaseExecutedTask;
import ru.yoomoney.gradle.plugins.release.CheckReleaseTask;
import ru.yoomoney.gradle.plugins.release.PostReleaseTask;
import ru.yoomoney.gradle.plugins.release.PreReleaseCommitTask;
import ru.yoomoney.gradle.plugins.release.PreReleaseRotateVersionTask;
import ru.yoomoney.gradle.plugins.release.PullRequestInfoProvider;
import ru.yoomoney.gradle.plugins.release.PullRequestLinkSettings;
import ru.yoomoney.gradle.plugins.release.ReleaseExtension;
import ru.yoomoney.gradle.plugins.release.changelog.CheckChangeLogTask;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\n"}, d2={"Lru/yoomoney/gradle/plugins/release/ReleasePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "afterEvaluate", "", "project", "apply", "configPreReleaseTaskOrder", "configReleaseTaskOrder", "artifact-release-plugin"})
public final class ReleasePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getExtensions().create("releaseSettings", ReleaseExtension.class, new Object[0]);
        project.getTasks().create("checkChangelog", CheckChangeLogTask.class, ReleasePlugin::apply$lambda-0);
        project.getTasks().create("preReleaseRotateVersion", PreReleaseRotateVersionTask.class, ReleasePlugin::apply$lambda-1);
        project.getTasks().create("checkRelease", CheckReleaseTask.class, ReleasePlugin::apply$lambda-2);
        project.getTasks().create("preReleaseCheckExecuted", CheckPreReleaseExecutedTask.class, ReleasePlugin::apply$lambda-3);
        project.getTasks().create("preRelease", PreReleaseCommitTask.class, ReleasePlugin::apply$lambda-4);
        project.getTasks().create("release", PostReleaseTask.class, ReleasePlugin::apply$lambda-5);
        this.afterEvaluate(project);
    }

    private final void afterEvaluate(Project project) {
        project.afterEvaluate(arg_0 -> ReleasePlugin.afterEvaluate$lambda-6(this, project, arg_0));
    }

    private final void configReleaseTaskOrder(Project project) {
        Object[] objectArray;
        List<String> releaseTasks = ((ReleaseExtension)project.getExtensions().getByType(ReleaseExtension.class)).getReleaseTasks();
        if (releaseTasks.size() > 0) {
            int n = 1;
            int n2 = releaseTasks.size();
            if (n < n2) {
                do {
                    int i = n++;
                    Object[] objectArray2 = new Object[]{releaseTasks.get(i - 1)};
                    project.getTasks().getByName(releaseTasks.get(i)).dependsOn(objectArray2);
                } while (n < n2);
            }
            objectArray = new Object[]{CollectionsKt.last(releaseTasks)};
            project.getTasks().getByName("preReleaseCheckExecuted").dependsOn(objectArray);
        }
        objectArray = new Object[]{"preReleaseCheckExecuted"};
        project.getTasks().getByName("release").dependsOn(objectArray);
    }

    private final void configPreReleaseTaskOrder(Project project) {
        Object[] objectArray;
        List<String> preReleaseTasks = ((ReleaseExtension)project.getExtensions().getByType(ReleaseExtension.class)).getPreReleaseTasks();
        if (preReleaseTasks.size() > 0) {
            Object[] objectArray2 = new Object[]{"preReleaseRotateVersion"};
            project.getTasks().getByName(preReleaseTasks.get(0)).dependsOn(objectArray2);
            int n = 1;
            int n2 = preReleaseTasks.size();
            if (n < n2) {
                do {
                    int i = n++;
                    Object[] objectArray3 = new Object[]{preReleaseTasks.get(i - 1)};
                    project.getTasks().getByName(preReleaseTasks.get(i)).dependsOn(objectArray3);
                } while (n < n2);
            }
            objectArray = new Object[]{CollectionsKt.last(preReleaseTasks)};
            project.getTasks().getByName("preRelease").dependsOn(objectArray);
        } else {
            objectArray = new Object[]{"checkRelease"};
            project.getTasks().getByName("preRelease").dependsOn(objectArray);
        }
        objectArray = new Object[]{"checkChangelog"};
        project.getTasks().getByName("preReleaseRotateVersion").dependsOn(objectArray);
        objectArray = new Object[]{"preReleaseRotateVersion"};
        project.getTasks().getByName("checkRelease").dependsOn(objectArray);
    }

    private static final void apply$lambda-0(CheckChangeLogTask it) {
        it.setGroup("verification");
        it.setDescription("Check that changelog has next version description");
    }

    private static final void apply$lambda-1(PreReleaseRotateVersionTask it) {
        it.setGroup("release");
        it.setDescription("Update version in gradle.property, rotate CHANGELOG.md");
    }

    private static final void apply$lambda-2(CheckReleaseTask it) {
        it.setGroup("release");
        it.setDescription("Fail build if push unsuccessful or tag already exist");
    }

    private static final void apply$lambda-3(CheckPreReleaseExecutedTask it) {
        it.setGroup("release");
        it.setDescription("Fail build if no preRelease was executed");
    }

    private static final void apply$lambda-4(PreReleaseCommitTask it) {
        it.setGroup("release");
        it.setDescription("Commit all changes, add tag with version");
    }

    private static final void apply$lambda-5(PostReleaseTask it) {
        it.setGroup("release");
        it.setDescription("Execute user release tasks, append markers to changelog, up gradle.property patch version, append snapshot to version, git push");
    }

    private static final void afterEvaluate$lambda-6(ReleasePlugin this$0, Project $project, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.configReleaseTaskOrder(it);
        this$0.configPreReleaseTaskOrder(it);
        ReleaseExtension releaseExtension = (ReleaseExtension)$project.getExtensions().getByType(ReleaseExtension.class);
        String string = releaseExtension.getGitEmail();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        String string3 = releaseExtension.getGitUsername();
        Intrinsics.checkNotNull((Object)string3);
        String string4 = string3;
        String string5 = releaseExtension.getPathToGitPrivateSshKey();
        String string6 = releaseExtension.getPassphraseToGitPrivateSshKey();
        GitSettings gitSettings = new GitSettings(string4, string2, string5, string6);
        string4 = it.getTasks().getByName("checkRelease");
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.CheckReleaseTask");
        }
        CheckReleaseTask checkReleaseTask = (CheckReleaseTask)((Object)string4);
        checkReleaseTask.setGitSettings(gitSettings);
        string5 = it.getTasks().getByName("release");
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.PostReleaseTask");
        }
        PostReleaseTask postReleaseTask = (PostReleaseTask)((Object)string5);
        postReleaseTask.setGitSettings(gitSettings);
        string6 = it.getTasks().getByName("preReleaseRotateVersion");
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.PreReleaseRotateVersionTask");
        }
        PreReleaseRotateVersionTask preReleaseRotateVersionTask = (PreReleaseRotateVersionTask)((Object)string6);
        preReleaseRotateVersionTask.setGitSettings(gitSettings);
        boolean bl = releaseExtension.getAddPullRequestLinkToChangelog();
        PullRequestInfoProvider pullRequestInfoProvider = PullRequestInfoProvider.Companion.fromName(releaseExtension.getPullRequestInfoProvider());
        Intrinsics.checkNotNull((Object)((Object)pullRequestInfoProvider));
        PullRequestInfoProvider pullRequestInfoProvider2 = pullRequestInfoProvider;
        String string7 = releaseExtension.getBitbucketApiToken();
        String string8 = releaseExtension.getGithubAccessToken();
        preReleaseRotateVersionTask.setPullRequestLinkSettings(new PullRequestLinkSettings(bl, pullRequestInfoProvider2, string8, string7));
        pullRequestInfoProvider2 = it.getTasks().getByName("preRelease");
        if (pullRequestInfoProvider2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.PreReleaseCommitTask");
        }
        PreReleaseCommitTask preReleaseCommitTask = (PreReleaseCommitTask)((Object)pullRequestInfoProvider2);
        preReleaseCommitTask.setGitSettings(gitSettings);
        string7 = it.getTasks().getByName("checkChangelog");
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.changelog.CheckChangeLogTask");
        }
        CheckChangeLogTask checkChangeLogTask = (CheckChangeLogTask)((Object)string7);
        checkChangeLogTask.setChangelogRequired(releaseExtension.getChangelogRequired());
    }
}

