/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.release.PullRequestLinkSettings;
import ru.yoomoney.gradle.plugins.release.changelog.ChangelogManager;
import ru.yoomoney.gradle.plugins.release.changelog.PullRequestLinkProvider;
import ru.yoomoney.gradle.plugins.release.git.GitManager;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;
import ru.yoomoney.gradle.plugins.release.version.GradlePropertyVersionManager;
import ru.yoomoney.gradle.plugins.release.version.ReleaseInfoStorage;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lru/yoomoney/gradle/plugins/release/PreReleaseRotateVersionTask;", "Lorg/gradle/api/DefaultTask;", "()V", "gitSettings", "Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "getGitSettings", "()Lru/yoomoney/gradle/plugins/release/git/GitSettings;", "setGitSettings", "(Lru/yoomoney/gradle/plugins/release/git/GitSettings;)V", "pullRequestLinkSettings", "Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;", "getPullRequestLinkSettings", "()Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;", "setPullRequestLinkSettings", "(Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;)V", "preReleaseByChangelog", "", "changelog", "Ljava/io/File;", "gradlePropertyVersionManager", "Lru/yoomoney/gradle/plugins/release/version/GradlePropertyVersionManager;", "releaseInfoStorage", "Lru/yoomoney/gradle/plugins/release/version/ReleaseInfoStorage;", "gitManager", "Lru/yoomoney/gradle/plugins/release/git/GitManager;", "rotateVersion", "", "Companion", "artifact-release-plugin"})
public class PreReleaseRotateVersionTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public GitSettings gitSettings;
    public PullRequestLinkSettings pullRequestLinkSettings;
    @NotNull
    private static final Logger log;

    @Input
    @NotNull
    public final GitSettings getGitSettings() {
        GitSettings gitSettings = this.gitSettings;
        if (gitSettings != null) {
            return gitSettings;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"gitSettings");
        return null;
    }

    public final void setGitSettings(@NotNull GitSettings gitSettings) {
        Intrinsics.checkNotNullParameter((Object)gitSettings, (String)"<set-?>");
        this.gitSettings = gitSettings;
    }

    @Input
    @NotNull
    public final PullRequestLinkSettings getPullRequestLinkSettings() {
        PullRequestLinkSettings pullRequestLinkSettings = this.pullRequestLinkSettings;
        if (pullRequestLinkSettings != null) {
            return pullRequestLinkSettings;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pullRequestLinkSettings");
        return null;
    }

    public final void setPullRequestLinkSettings(@NotNull PullRequestLinkSettings pullRequestLinkSettings) {
        Intrinsics.checkNotNullParameter((Object)pullRequestLinkSettings, (String)"<set-?>");
        this.pullRequestLinkSettings = pullRequestLinkSettings;
    }

    private final String preReleaseByChangelog(File changelog, GradlePropertyVersionManager gradlePropertyVersionManager, ReleaseInfoStorage releaseInfoStorage, GitManager gitManager) {
        ChangelogManager changelogManager = new ChangelogManager(changelog);
        String githubPullRequestLink = this.getPullRequestLinkSettings().getPullRequestLinkInChangelogEnabled() ? new PullRequestLinkProvider(gitManager, this.getPullRequestLinkSettings()).getReleasePullRequestLink() : null;
        ChangelogManager.ChangelogReleaseInfo nextVersion = changelogManager.updateToNextVersion(githubPullRequestLink);
        gradlePropertyVersionManager.updateVersion(nextVersion.getReleaseVersion());
        releaseInfoStorage.storeChangelog(nextVersion.getReleaseDescriptionMd());
        return nextVersion.getReleaseVersion();
    }

    @TaskAction
    public final void rotateVersion() {
        String string;
        File file = this.getProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        GitManager gitManager = new GitManager(file, this.getGitSettings());
        Set<String> uncommittedChanges = gitManager.getUncommittedChanges();
        if (!uncommittedChanges.isEmpty()) {
            throw new GradleException(Intrinsics.stringPlus((String)"There are uncommitted changes \n", (Object)CollectionsKt.joinToString$default((Iterable)uncommittedChanges, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
        }
        Object[] objectArray = new Object[]{this.getProject().getVersion()};
        log.lifecycle("Start pre release: currentVersion = {}", objectArray);
        File file2 = this.getProject().file((Object)"gradle.properties");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.file(GradlePrope\u2026anager.DEFAULT_FILE_NAME)");
        GradlePropertyVersionManager projectVersionManager = new GradlePropertyVersionManager(file2);
        File changelogFile = this.getProject().file((Object)"CHANGELOG.md");
        File file3 = this.getProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"project.buildDir");
        ReleaseInfoStorage releaseInfoStorage = new ReleaseInfoStorage(file3);
        if (changelogFile.exists()) {
            Intrinsics.checkNotNullExpressionValue((Object)changelogFile, (String)"changelogFile");
            string = this.preReleaseByChangelog(changelogFile, projectVersionManager, releaseInfoStorage, gitManager);
        } else {
            log.lifecycle("Changelog rotate skip, " + changelogFile.getName() + " not found");
            string = projectVersionManager.removeSnapshotFromVersion();
        }
        String releaseVersion = string;
        Object[] objectArray2 = new Object[]{releaseVersion};
        log.lifecycle("Update " + projectVersionManager.getGradleProperty().getName() + ": releaseVersion={}", objectArray2);
        releaseInfoStorage.storeVersion(releaseVersion);
    }

    static {
        Logger logger = Logging.getLogger(PreReleaseRotateVersionTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PreReleaseRotateVersionTask::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/yoomoney/gradle/plugins/release/PreReleaseRotateVersionTask$Companion;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

