/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.github;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestQueryBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import ru.yoomoney.gradle.plugins.release.PreReleaseRotateVersionTask;
import ru.yoomoney.gradle.plugins.release.PullRequestLinkSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/yoomoney/gradle/plugins/release/github/GitHubClient;", "", "pullRequestLinkSettings", "Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;", "(Lru/yoomoney/gradle/plugins/release/PullRequestLinkSettings;)V", "github", "Lorg/kohsuke/github/GitHub;", "(Lorg/kohsuke/github/GitHub;)V", "getLatestPullRequest", "Lorg/kohsuke/github/GHPullRequest;", "project", "", "repository", "state", "Lorg/kohsuke/github/GHIssueState;", "Companion", "artifact-release-plugin"})
public final class GitHubClient {
    private final GitHub github;
    private static final Logger log;
    public static final Companion Companion;

    @Nullable
    public final GHPullRequest getLatestPullRequest(@NotNull String project, @NotNull String repository, @Nullable GHIssueState state) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        try {
            List list = this.github.getRepository(project + '/' + repository).queryPullRequests().state(state).sort(GHPullRequestQueryBuilder.Sort.UPDATED).direction(GHDirection.DESC).list().withPageSize(1).toList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"github.getRepository(\"$p\u2026                .toList()");
            return (GHPullRequest)CollectionsKt.firstOrNull((List)list);
        }
        catch (Exception ex) {
            log.lifecycle("Can't call github");
            return null;
        }
    }

    public GitHubClient(@NotNull GitHub github) {
        Intrinsics.checkParameterIsNotNull((Object)github, (String)"github");
        this.github = github;
    }

    public GitHubClient(@NotNull PullRequestLinkSettings pullRequestLinkSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pullRequestLinkSettings, (String)"pullRequestLinkSettings");
        GitHub gitHub = new GitHubBuilder().withOAuthToken(pullRequestLinkSettings.getGithubAccessToken()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)gitHub, (String)"GitHubBuilder()\n        \u2026                 .build()");
        this(gitHub);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logging.getLogger(PreReleaseRotateVersionTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(PreRel\u2026eVersionTask::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/yoomoney/gradle/plugins/release/github/GitHubClient$Companion;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

