/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release.changelog;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yoomoney.gradle.plugins.release.changelog.ChangelogManager;
import ru.yoomoney.gradle.plugins.release.version.ReleaseType;
import ru.yoomoney.gradle.plugins.release.version.SemanticVersionEditor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/ChangelogManager;", "", "changeLog", "Ljava/io/File;", "(Ljava/io/File;)V", "appendNextVersionDescriptionMarkers", "", "getCurrentDate", "", "getLastVersion", "getNexVersionDescription", "getNextVersion", "getNextVersionType", "Lru/yoomoney/gradle/plugins/release/version/ReleaseType;", "hasNextVersionInfo", "", "readContent", "updateToNextVersion", "Lru/yoomoney/gradle/plugins/release/changelog/ChangelogManager$ChangelogReleaseInfo;", "githubPullRequestLink", "ChangelogReleaseInfo", "Companion", "artifact-release-plugin"})
public final class ChangelogManager {
    private final File changeLog;
    private static final Logger log;
    @NotNull
    public static final String NEXT_VERSION_TYPE_MARKER = "### NEXT_VERSION_TYPE=MAJOR|MINOR|PATCH";
    @NotNull
    public static final String DESCRIPTION_BEGIN_MARKER = "### NEXT_VERSION_DESCRIPTION_BEGIN";
    @NotNull
    public static final String DESCRIPTION_END_MARKER = "### NEXT_VERSION_DESCRIPTION_END";
    @NotNull
    public static final String DEFAULT_FILE_NAME = "CHANGELOG.md";
    private static final Regex previousVersionRegexp;
    private static final Regex nextVersionTypeRegexp;
    public static final Companion Companion;

    public final boolean hasNextVersionInfo() {
        CharSequence charSequence = this.getNexVersionDescription();
        boolean bl = false;
        return charSequence.length() > 0 && this.getNextVersionType() != null;
    }

    private final ReleaseType getNextVersionType() {
        for (String line : FilesKt.readLines$default((File)this.changeLog, null, (int)1, null)) {
            MatchResult matchResult = nextVersionTypeRegexp.matchEntire((CharSequence)line);
            if (matchResult == null) continue;
            return ReleaseType.valueOf((String)matchResult.getGroupValues().get(1));
        }
        return null;
    }

    private final String getLastVersion() {
        for (String line : FilesKt.readLines$default((File)this.changeLog, null, (int)1, null)) {
            MatchResult matchEntire = previousVersionRegexp.matchEntire((CharSequence)line);
            if (matchEntire == null) continue;
            return (String)matchEntire.getGroupValues().get(1);
        }
        return null;
    }

    @Nullable
    public final String getNextVersion() {
        ReleaseType releaseType = this.getNextVersionType();
        if (releaseType == null) {
            return null;
        }
        ReleaseType nextVersionType = releaseType;
        String lastVersion = this.getLastVersion();
        return new SemanticVersionEditor(lastVersion).increment(nextVersionType);
    }

    @NotNull
    public final ChangelogReleaseInfo updateToNextVersion(@Nullable String githubPullRequestLink) {
        String fullChangeLog2;
        String nextVersionDescription = this.getNexVersionDescription();
        ReleaseType nextVersionType = this.getNextVersionType();
        CharSequence charSequence = nextVersionDescription;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new GradleException("Changelog doesn't have new version description, skip update to next version");
        }
        if (nextVersionType == null) {
            throw (Throwable)new GradleException("Changelog doesn't have new version type, skip update to next version");
        }
        String lastVersion = this.getLastVersion();
        String nextVersion = new SemanticVersionEditor(lastVersion).increment(nextVersionType);
        log.lifecycle("Changelog release version info :lastVersion={}, nextVersion={}, type={} description=\n{}", new Object[]{lastVersion, nextVersion, nextVersionType, nextVersionDescription});
        String string = fullChangeLog2 = FilesKt.readLines$default((File)this.changeLog, null, (int)1, null).stream().filter(updateToNextVersion.fullChangeLog.1.INSTANCE).collect(Collectors.joining("\n"));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fullChangeLog");
        int indexOfBeginMarker = StringsKt.indexOf$default((CharSequence)string, (String)DESCRIPTION_BEGIN_MARKER, (int)0, (boolean)false, (int)6, null);
        int indexOfEndMarker = StringsKt.indexOf$default((CharSequence)fullChangeLog2, (String)DESCRIPTION_END_MARKER, (int)0, (boolean)false, (int)6, null);
        String string2 = fullChangeLog2;
        int n = 0;
        int n2 = 0;
        String string3 = string2.substring(n, indexOfBeginMarker);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String header = string3;
        String string4 = fullChangeLog2;
        n2 = indexOfEndMarker + DESCRIPTION_END_MARKER.length();
        boolean bl2 = false;
        String string5 = string4.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String footer = string5;
        PrintWriter writer = new PrintWriter(this.changeLog);
        CharSequence charSequence2 = header;
        bl2 = false;
        if (charSequence2.length() > 0) {
            writer.println(header);
        }
        StringBuilder stringBuilder = new StringBuilder().append("## [").append(nextVersion).append("](");
        String string6 = githubPullRequestLink;
        if (string6 == null) {
            string6 = "";
        }
        writer.println(stringBuilder.append(string6).append(") (").append(this.getCurrentDate()).append(')').toString());
        writer.println();
        writer.println(nextVersionDescription);
        writer.print(footer);
        writer.close();
        return new ChangelogReleaseInfo(nextVersion, nextVersionDescription);
    }

    private final String getCurrentDate() {
        String string = new SimpleDateFormat("dd-MM-YYYY").format(new Date());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SimpleDateFormat(\"dd-MM-YYYY\").format(Date())");
        return string;
    }

    public final void appendNextVersionDescriptionMarkers() {
        String newChangeLogContent;
        String string = newChangeLogContent = "### NEXT_VERSION_TYPE=MAJOR|MINOR|PATCH\n### NEXT_VERSION_DESCRIPTION_BEGIN\n### NEXT_VERSION_DESCRIPTION_END\n" + this.readContent();
        Path path = this.changeLog.toPath();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        Files.write(path, byArray2, new OpenOption[0]);
    }

    private final String readContent() {
        return CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)this.changeLog, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getNexVersionDescription() {
        StringBuilder result = new StringBuilder();
        boolean afterBegin = false;
        Iterator iterator = FilesKt.readLines$default((File)this.changeLog, null, (int)1, null).iterator();
        while (iterator.hasNext()) {
            String line;
            String string = line = (String)iterator.next();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String trimmedLine = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (!afterBegin && Intrinsics.areEqual((Object)trimmedLine, (Object)DESCRIPTION_BEGIN_MARKER)) {
                afterBegin = true;
                continue;
            }
            if (afterBegin && Intrinsics.areEqual((Object)trimmedLine, (Object)DESCRIPTION_END_MARKER)) {
                afterBegin = false;
                break;
            }
            if (!afterBegin) continue;
            result.append(trimmedLine).append('\n');
        }
        if (afterBegin) {
            return "";
        }
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        String string3 = string;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    public ChangelogManager(@NotNull File changeLog) {
        Intrinsics.checkParameterIsNotNull((Object)changeLog, (String)"changeLog");
        this.changeLog = changeLog;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logging.getLogger(ChangelogManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(ChangelogManager::class.java)");
        log = logger;
        previousVersionRegexp = new Regex("^## \\[(\\d+\\.\\d+\\.\\d+)\\]\\(.*\\)\\s+\\(\\d+-\\d+-\\d+\\)$");
        nextVersionTypeRegexp = new Regex("^### NEXT_VERSION_TYPE=(MAJOR|MINOR|PATCH)$");
    }

    public static final /* synthetic */ Regex access$getNextVersionTypeRegexp$cp() {
        return nextVersionTypeRegexp;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/ChangelogManager$ChangelogReleaseInfo;", "", "releaseVersion", "", "releaseDescriptionMd", "(Ljava/lang/String;Ljava/lang/String;)V", "getReleaseDescriptionMd", "()Ljava/lang/String;", "getReleaseVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "artifact-release-plugin"})
    public static final class ChangelogReleaseInfo {
        @NotNull
        private final String releaseVersion;
        @NotNull
        private final String releaseDescriptionMd;

        @NotNull
        public final String getReleaseVersion() {
            return this.releaseVersion;
        }

        @NotNull
        public final String getReleaseDescriptionMd() {
            return this.releaseDescriptionMd;
        }

        public ChangelogReleaseInfo(@NotNull String releaseVersion, @NotNull String releaseDescriptionMd) {
            Intrinsics.checkParameterIsNotNull((Object)releaseVersion, (String)"releaseVersion");
            Intrinsics.checkParameterIsNotNull((Object)releaseDescriptionMd, (String)"releaseDescriptionMd");
            this.releaseVersion = releaseVersion;
            this.releaseDescriptionMd = releaseDescriptionMd;
        }

        @NotNull
        public final String component1() {
            return this.releaseVersion;
        }

        @NotNull
        public final String component2() {
            return this.releaseDescriptionMd;
        }

        @NotNull
        public final ChangelogReleaseInfo copy(@NotNull String releaseVersion, @NotNull String releaseDescriptionMd) {
            Intrinsics.checkParameterIsNotNull((Object)releaseVersion, (String)"releaseVersion");
            Intrinsics.checkParameterIsNotNull((Object)releaseDescriptionMd, (String)"releaseDescriptionMd");
            return new ChangelogReleaseInfo(releaseVersion, releaseDescriptionMd);
        }

        public static /* synthetic */ ChangelogReleaseInfo copy$default(ChangelogReleaseInfo changelogReleaseInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = changelogReleaseInfo.releaseVersion;
            }
            if ((n & 2) != 0) {
                string2 = changelogReleaseInfo.releaseDescriptionMd;
            }
            return changelogReleaseInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ChangelogReleaseInfo(releaseVersion=" + this.releaseVersion + ", releaseDescriptionMd=" + this.releaseDescriptionMd + ")";
        }

        public int hashCode() {
            String string = this.releaseVersion;
            String string2 = this.releaseDescriptionMd;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ChangelogReleaseInfo)) break block3;
                    ChangelogReleaseInfo changelogReleaseInfo = (ChangelogReleaseInfo)object;
                    if (!Intrinsics.areEqual((Object)this.releaseVersion, (Object)changelogReleaseInfo.releaseVersion) || !Intrinsics.areEqual((Object)this.releaseDescriptionMd, (Object)changelogReleaseInfo.releaseDescriptionMd)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lru/yoomoney/gradle/plugins/release/changelog/ChangelogManager$Companion;", "", "()V", "DEFAULT_FILE_NAME", "", "DESCRIPTION_BEGIN_MARKER", "DESCRIPTION_END_MARKER", "NEXT_VERSION_TYPE_MARKER", "log", "Lorg/gradle/api/logging/Logger;", "nextVersionTypeRegexp", "Lkotlin/text/Regex;", "previousVersionRegexp", "artifact-release-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

