/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.gradle.plugins.release;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import ru.yoomoney.gradle.plugins.release.CheckPreReleaseExecutedTask;
import ru.yoomoney.gradle.plugins.release.CheckReleaseTask;
import ru.yoomoney.gradle.plugins.release.PostReleaseTask;
import ru.yoomoney.gradle.plugins.release.PreReleaseCommitTask;
import ru.yoomoney.gradle.plugins.release.PreReleaseRotateVersionTask;
import ru.yoomoney.gradle.plugins.release.PullRequestInfoProvider;
import ru.yoomoney.gradle.plugins.release.PullRequestLinkSettings;
import ru.yoomoney.gradle.plugins.release.ReleaseExtension;
import ru.yoomoney.gradle.plugins.release.ReleasePlugin;
import ru.yoomoney.gradle.plugins.release.changelog.CheckChangeLogTask;
import ru.yoomoney.gradle.plugins.release.git.GitSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\n"}, d2={"Lru/yoomoney/gradle/plugins/release/ReleasePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "afterEvaluate", "", "project", "apply", "configPreReleaseTaskOrder", "configReleaseTaskOrder", "artifact-release-plugin"})
public final class ReleasePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getExtensions().create("releaseSettings", ReleaseExtension.class, new Object[0]);
        project.getTasks().create("checkChangelog", CheckChangeLogTask.class, (Action)apply.1.INSTANCE);
        project.getTasks().create("preReleaseRotateVersion", PreReleaseRotateVersionTask.class, (Action)apply.2.INSTANCE);
        project.getTasks().create("checkRelease", CheckReleaseTask.class, (Action)apply.3.INSTANCE);
        project.getTasks().create("preReleaseCheckExecuted", CheckPreReleaseExecutedTask.class, (Action)apply.4.INSTANCE);
        project.getTasks().create("preRelease", PreReleaseCommitTask.class, (Action)apply.5.INSTANCE);
        project.getTasks().create("release", PostReleaseTask.class, (Action)apply.6.INSTANCE);
        this.afterEvaluate(project);
    }

    private final void afterEvaluate(Project project) {
        project.afterEvaluate((Action)new Action<Project>(this, project){
            final /* synthetic */ ReleasePlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                Project project = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                ReleasePlugin.access$configReleaseTaskOrder(this.this$0, project);
                ReleasePlugin.access$configPreReleaseTaskOrder(this.this$0, it);
                ReleaseExtension releaseExtension = (ReleaseExtension)this.$project.getExtensions().getByType(ReleaseExtension.class);
                String string = releaseExtension.getGitEmail();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = releaseExtension.getGitUsername();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = releaseExtension.getPassphraseToGitPrivateSshKey();
                String string4 = releaseExtension.getPathToGitPrivateSshKey();
                String string5 = string2;
                String string6 = string;
                GitSettings gitSettings = new GitSettings(string5, string6, string4, string3);
                Task task = it.getTasks().getByName("checkRelease");
                if (task == null) {
                    throw new TypeCastException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.CheckReleaseTask");
                }
                CheckReleaseTask checkReleaseTask = (CheckReleaseTask)task;
                checkReleaseTask.setGitSettings(gitSettings);
                Task task2 = it.getTasks().getByName("release");
                if (task2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.PostReleaseTask");
                }
                PostReleaseTask postReleaseTask = (PostReleaseTask)task2;
                postReleaseTask.setGitSettings(gitSettings);
                Task task3 = it.getTasks().getByName("preReleaseRotateVersion");
                if (task3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.PreReleaseRotateVersionTask");
                }
                PreReleaseRotateVersionTask preReleaseRotateVersionTask = (PreReleaseRotateVersionTask)task3;
                preReleaseRotateVersionTask.setGitSettings(gitSettings);
                boolean bl = releaseExtension.getAddPullRequestLinkToChangelog();
                PullRequestInfoProvider pullRequestInfoProvider = PullRequestInfoProvider.Companion.fromName(releaseExtension.getPullRequestInfoProvider());
                if (pullRequestInfoProvider == null) {
                    Intrinsics.throwNpe();
                }
                string6 = releaseExtension.getGithubAccessToken();
                String string7 = releaseExtension.getBitbucketPassword();
                String string8 = releaseExtension.getBitbucketUser();
                preReleaseRotateVersionTask.setPullRequestLinkSettings(new PullRequestLinkSettings(bl, pullRequestInfoProvider, string6, string8, string7));
                Task task4 = it.getTasks().getByName("preRelease");
                if (task4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.PreReleaseCommitTask");
                }
                PreReleaseCommitTask preReleaseCommitTask = (PreReleaseCommitTask)task4;
                preReleaseCommitTask.setGitSettings(gitSettings);
                Task task5 = it.getTasks().getByName("checkChangelog");
                if (task5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type ru.yoomoney.gradle.plugins.release.changelog.CheckChangeLogTask");
                }
                CheckChangeLogTask checkChangeLogTask = (CheckChangeLogTask)task5;
                checkChangeLogTask.setChangelogRequired(releaseExtension.getChangelogRequired());
            }
            {
                this.this$0 = releasePlugin;
                this.$project = project;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void configReleaseTaskOrder(Project project) {
        List<String> releaseTasks = ((ReleaseExtension)project.getExtensions().getByType(ReleaseExtension.class)).getReleaseTasks();
        if (releaseTasks.size() > 0) {
            int n = 1;
            int n2 = releaseTasks.size();
            while (n < n2) {
                void i;
                project.getTasks().getByName(releaseTasks.get((int)i)).dependsOn(new Object[]{releaseTasks.get((int)(i - true))});
                ++i;
            }
            project.getTasks().getByName("preReleaseCheckExecuted").dependsOn(new Object[]{CollectionsKt.last(releaseTasks)});
        }
        project.getTasks().getByName("release").dependsOn(new Object[]{"preReleaseCheckExecuted"});
    }

    /*
     * WARNING - void declaration
     */
    private final void configPreReleaseTaskOrder(Project project) {
        List<String> preReleaseTasks = ((ReleaseExtension)project.getExtensions().getByType(ReleaseExtension.class)).getPreReleaseTasks();
        if (preReleaseTasks.size() > 0) {
            project.getTasks().getByName(preReleaseTasks.get(0)).dependsOn(new Object[]{"preReleaseRotateVersion"});
            int n = 1;
            int n2 = preReleaseTasks.size();
            while (n < n2) {
                void i;
                project.getTasks().getByName(preReleaseTasks.get((int)i)).dependsOn(new Object[]{preReleaseTasks.get((int)(i - true))});
                ++i;
            }
            project.getTasks().getByName("preRelease").dependsOn(new Object[]{CollectionsKt.last(preReleaseTasks)});
        } else {
            project.getTasks().getByName("preRelease").dependsOn(new Object[]{"checkRelease"});
        }
        project.getTasks().getByName("preReleaseRotateVersion").dependsOn(new Object[]{"checkChangelog"});
        project.getTasks().getByName("checkRelease").dependsOn(new Object[]{"preReleaseRotateVersion"});
    }

    public static final /* synthetic */ void access$configReleaseTaskOrder(ReleasePlugin $this, Project project) {
        $this.configReleaseTaskOrder(project);
    }

    public static final /* synthetic */ void access$configPreReleaseTaskOrder(ReleasePlugin $this, Project project) {
        $this.configPreReleaseTaskOrder(project);
    }
}

