/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.properties.providers;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import ru.yandex.qatools.properties.annotations.Resource;
import ru.yandex.qatools.properties.providers.PropertyProvider;
import ru.yandex.qatools.properties.utils.PropertiesUtils;

public class DefaultPropertyProvider
implements PropertyProvider {
    @Override
    public <T> Properties provide(T bean, Properties properties) {
        String path;
        Class<?> clazz = bean.getClass();
        if (this.have(clazz, Resource.Classpath.class)) {
            path = this.classpath(clazz, properties);
            properties.putAll((Map<?, ?>)PropertiesUtils.readProperties(this.getClassLoader().getResourceAsStream(path)));
        }
        if (this.have(clazz, Resource.File.class)) {
            path = this.filepath(clazz, properties);
            properties.putAll((Map<?, ?>)PropertiesUtils.readProperties(new File(path)));
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    protected boolean have(Class<?> clazz, Class<? extends Annotation> anno) {
        return clazz.isAnnotationPresent(anno);
    }

    protected String filepath(Class<?> clazz, Properties properties) {
        return clazz.getAnnotation(Resource.File.class).value();
    }

    protected String classpath(Class<?> clazz, Properties properties) {
        return clazz.getAnnotation(Resource.Classpath.class).value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader;
        }
        catch (SecurityException securityException) {}
        finally {
            if (classLoader == null) {
                return ClassLoader.getSystemClassLoader();
            }
            return classLoader;
        }
    }
}

