/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.properties.decorators;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Use;
import ru.yandex.qatools.properties.converters.URIConverter;
import ru.yandex.qatools.properties.decorators.FieldDecorator;

public class DefaultFieldDecorator
implements FieldDecorator {
    private final ConvertUtilsBean converters = BeanUtilsBean.getInstance().getConvertUtils();
    private Properties properties;

    public DefaultFieldDecorator(Properties properties) {
        this.converters.register(true, false, -1);
        this.converters.register((Converter)new URIConverter(), URI.class);
        this.properties = properties;
    }

    @Override
    public Object decorate(Field field) {
        if (!field.isAnnotationPresent(Property.class)) {
            return null;
        }
        String key = field.getAnnotation(Property.class).value();
        if (key == null || "".equals(key)) {
            return null;
        }
        String value = this.properties.getProperty(key);
        if (value == null || "".equals(value)) {
            return null;
        }
        Converter converter = this.getConverterFrom(field);
        if (converter == null) {
            return null;
        }
        try {
            return converter.convert(field.getType(), (Object)this.properties.getProperty(key));
        }
        catch (ConversionException e) {
            return null;
        }
    }

    private Converter getConverterFrom(Field field) {
        if (field.isAnnotationPresent(Use.class)) {
            return this.createNewInstanceFromUseAnnotations(field);
        }
        return this.converters.lookup(field.getType());
    }

    private Converter createNewInstanceFromUseAnnotations(Field field) {
        try {
            return field.getAnnotation(Use.class).value().newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

