/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.camelot.plugin;

import com.codahale.metrics.graphite.Graphite;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.camelot.api.annotations.ConfigValue;
import ru.yandex.qatools.camelot.api.annotations.Filter;
import ru.yandex.qatools.camelot.api.annotations.Processor;
import ru.yandex.qatools.camelot.plugin.GraphiteValue;

@Filter(instanceOf={GraphiteValue.class})
public class GraphiteReportProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @ConfigValue(value="graphite.host")
    private String host;
    @ConfigValue(value="graphite.port")
    private int port;

    @Processor
    public void process(GraphiteValue event) {
        if (StringUtils.isBlank((CharSequence)this.host)) {
            return;
        }
        this.logger.info(String.format("Sending %s to graphite at %s:%d", event, this.host, this.port));
        try {
            Graphite graphite = new Graphite(new InetSocketAddress(this.host, this.port));
            graphite.connect();
            graphite.send(event.getName(), event.getValue(), event.getTimestamp());
            graphite.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to stream value to graphite:", (Throwable)e);
        }
    }
}

