/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jenkins.plugins.debuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jedi.functional.FunctionalPrimitives;

public class VersionHelper {
    private final String separator;
    private final List<String> versionElements;
    private final int minorEntry;
    private final int revisionEntry;

    public VersionHelper(String version) {
        this(version, '.');
    }

    public VersionHelper(String version, char separatorCharacter) {
        this(version.split("\\" + separatorCharacter), "" + separatorCharacter);
    }

    public VersionHelper(String[] versionElements, String separator) {
        this.versionElements = new ArrayList<String>(Arrays.asList(versionElements));
        this.separator = separator;
        this.minorEntry = this.getMinorEntry();
        this.revisionEntry = this.getRevisionEntry();
    }

    private int getMinorEntry() {
        int lastNumeric = -1;
        for (int i = this.versionElements.size() - 1; i >= 0; --i) {
            try {
                Integer.parseInt(this.versionElements.get(i));
                lastNumeric = i;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
        }
        return lastNumeric;
    }

    private int getRevisionEntry() {
        for (int i = 0; i < this.versionElements.size(); ++i) {
            if (!this.versionElements.get(i).startsWith("r")) continue;
            return i;
        }
        return -1;
    }

    public void setRevision(String revision) {
        String revisionElement = "r" + revision;
        if (this.revisionEntry >= 0) {
            this.versionElements.set(this.revisionEntry, revisionElement);
        } else {
            this.versionElements.add(revisionElement);
        }
    }

    public String getRevision() {
        if (this.revisionEntry >= 0) {
            return this.versionElements.get(this.revisionEntry).substring(1);
        }
        return "";
    }

    public int getMinorVersion() {
        if (this.minorEntry >= 0) {
            return Integer.parseInt(this.versionElements.get(this.minorEntry));
        }
        return 0;
    }

    public void setMinorVersion(int newVersion) {
        String versionElement = Integer.toString(newVersion);
        if (this.minorEntry >= 0) {
            this.versionElements.set(this.minorEntry, versionElement);
        } else {
            this.versionElements.add(versionElement);
        }
    }

    public String toString() {
        return FunctionalPrimitives.join(this.versionElements, (String)this.separator);
    }
}

