/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.quality;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Project;
import ru.vyarus.gradle.plugin.quality.QualityExtension;

public class ConfigLoader
implements GroovyObject {
    private final String checkstyle;
    private final String checkstyleSuppressions;
    private final String pmd;
    private final String cpdXsl;
    private final String spotbugsExclude;
    private final String codenarc;
    private Project project;
    private File configDir;
    private File tmpConfigDir;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ConfigLoader(Project project) {
        Project project2;
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this.checkstyle = string6 = "checkstyle/checkstyle.xml";
        this.checkstyleSuppressions = string5 = "checkstyle/suppressions.xml";
        this.pmd = string4 = "pmd/pmd.xml";
        this.cpdXsl = string3 = "cpd/cpdhtml.xslt";
        this.spotbugsExclude = string2 = "spotbugs/exclude.xml";
        this.codenarc = string = "codenarc/codenarc.xml";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = project2 = project;
    }

    public File resolveCheckstyleConfig(boolean copyDefaultFile) {
        return this.resolve(this.checkstyle, copyDefaultFile);
    }

    public File resolveCheckstyleConfigDir() {
        File path = new File(this.configDir, this.checkstyle).getParentFile();
        return path.exists() ? path : this.resolveCheckstyleConfig(true).getParentFile();
    }

    public File resolvePmdConfig(boolean copyDefaultFile) {
        return this.resolve(this.pmd, copyDefaultFile);
    }

    public File resolveCpdXsl(boolean copyDefaultFile) {
        return this.resolve(this.cpdXsl, copyDefaultFile);
    }

    public File resolveSpotbugsExclude(boolean copyDefaultFile) {
        return this.resolve(this.spotbugsExclude, copyDefaultFile);
    }

    public File resolveCodenarcConfig(boolean copyDefaultFile) {
        return this.resolve(this.codenarc, copyDefaultFile);
    }

    public void initUserConfigs(boolean override) {
        Reference override2 = new Reference((Object)override);
        this.init();
        public final class _initUserConfigs_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference override;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _initUserConfigs_closure1(Object _outerInstance, Object _thisObject, Reference override) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.override = reference = override;
            }

            public File doCall(Object it) {
                return ((ConfigLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ConfigLoader.class)).copyConfig(((ConfigLoader)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ConfigLoader.class)).getConfigDir(), ShortTypeHandling.castToString((Object)it), DefaultTypeTransformation.booleanUnbox((Object)this.override.get()));
            }

            @Generated
            public boolean getOverride() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.override.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public File doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _initUserConfigs_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.checkstyle, this.checkstyleSuppressions, this.pmd, this.cpdXsl, this.codenarc, this.spotbugsExclude}), (Closure)new _initUserConfigs_closure1(this, this, override2));
    }

    private File resolve(String path, boolean copyDefaultFile) {
        this.init();
        File target = new File(this.configDir, path);
        boolean userFile = target.exists();
        if (userFile && copyDefaultFile) {
            this.project.getLogger().info("[plugin:quality] Using custom quality configuration: {}", (Object)this.project.relativePath((Object)target));
        }
        return userFile ? target : (copyDefaultFile ? this.copyConfig(this.tmpConfigDir, path, false) : new File(this.tmpConfigDir, path));
    }

    private void init() {
        if (this.configDir == null) {
            File file;
            File file2;
            this.configDir = file2 = this.project.getRootProject().file((Object)((QualityExtension)this.project.getExtensions().findByType(QualityExtension.class)).getConfigDir());
            this.tmpConfigDir = file = this.project.file((Object)new GStringImpl(new Object[]{this.project.getLayout().getBuildDirectory().get()}, new String[]{"", "/quality-configs/"}));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File copyConfig(File parent, String path, boolean override) {
        File target = new File(parent, path);
        if (target.exists() && !override) {
            return target;
        }
        ConfigLoader configLoader = this;
        synchronized (configLoader) {
            if (!(!target.exists() || override)) return target;
            if (target.exists() && override) {
                target.delete();
            }
            if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{target.getParentFile().getAbsolutePath()}, new String[]{"Failed to create directories: ", ""})));
            }
            InputStream stream = this.getClass().getResourceAsStream(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"/ru/vyarus/quality/config/", ""})));
            if (stream == null) {
                throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"Default config file not found in classpath: ", ""})));
            }
            ResourceGroovyMethods.leftShift((File)target, (Object)IOGroovyMethods.getText((InputStream)stream));
            return target;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConfigLoader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ File pfaccess$0(ConfigLoader $that) {
        return $that.configDir;
    }

    @Generated
    public File resolveCheckstyleConfig() {
        CallSite[] callSiteArray = ConfigLoader.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.resolveCheckstyleConfig(true);
        }
        return this.resolveCheckstyleConfig(true);
    }

    @Generated
    public File resolvePmdConfig() {
        CallSite[] callSiteArray = ConfigLoader.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.resolvePmdConfig(true);
        }
        return this.resolvePmdConfig(true);
    }

    @Generated
    public File resolveCpdXsl() {
        CallSite[] callSiteArray = ConfigLoader.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.resolveCpdXsl(true);
        }
        return this.resolveCpdXsl(true);
    }

    @Generated
    public File resolveSpotbugsExclude() {
        CallSite[] callSiteArray = ConfigLoader.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.resolveSpotbugsExclude(true);
        }
        return this.resolveSpotbugsExclude(true);
    }

    @Generated
    public File resolveCodenarcConfig() {
        CallSite[] callSiteArray = ConfigLoader.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.resolveCodenarcConfig(true);
        }
        return this.resolveCodenarcConfig(true);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public File getConfigDir() {
        return this.configDir;
    }

    @Generated
    public void setConfigDir(File file) {
        this.configDir = file;
    }

    @Generated
    public File getTmpConfigDir() {
        return this.tmpConfigDir;
    }

    @Generated
    public void setTmpConfigDir(File file) {
        this.tmpConfigDir = file;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(ConfigLoader.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ConfigLoader.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

