/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import com.google.common.base.Preconditions;
import io.dropwizard.testing.ConfigOverride;
import java.util.List;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.test.util.ConfigurablePrefix;

public final class ConfigOverrideUtils {
    private ConfigOverrideUtils() {
    }

    public static String createPrefix(Class<?> type) {
        return RenderUtils.getClassName(type);
    }

    public static ConfigOverride[] convert(String prefix, String ... props) {
        ConfigOverride[] overrides = null;
        if (props != null && props.length > 0) {
            overrides = new ConfigOverride[props.length];
            int i = 0;
            for (String value : props) {
                int idx = value.indexOf(58);
                Preconditions.checkState((idx > 0 && idx < value.length() ? 1 : 0) != 0, (String)"Incorrect configuration override declaration: must be 'key: value', but found '%s'", (Object)value);
                overrides[i++] = ConfigOverride.config((String)prefix, (String)value.substring(0, idx).trim(), (String)value.substring(idx + 1).trim());
            }
        }
        return overrides;
    }

    public static ConfigOverride[] merge(ConfigOverride[] base, ConfigOverride ... addition) {
        if (addition == null || addition.length == 0) {
            return base;
        }
        if (base == null) {
            return addition;
        }
        ConfigOverride[] res = new ConfigOverride[base.length + addition.length];
        System.arraycopy(base, 0, res, 0, base.length);
        System.arraycopy(addition, 0, res, base.length, addition.length);
        return res;
    }

    public static <T extends ConfigOverride> ConfigOverride[] prepareOverrides(String prefix, List<T> values) {
        ConfigOverride[] res = null;
        if (!values.isEmpty()) {
            res = new ConfigOverride[values.size()];
            int i = 0;
            for (ConfigOverride value : values) {
                ((ConfigurablePrefix)value).setPrefix(prefix);
                res[i++] = value;
            }
        }
        return res;
    }
}

