/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.google.common.base.Preconditions;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.platform.commons.support.AnnotationSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.GuiceyTestSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.TestGuiceyApp;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.GuiceyExtensionsSupport;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideValue;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;

public class TestGuiceyAppExtension
extends GuiceyExtensionsSupport {
    private Config config;

    public TestGuiceyAppExtension() {
    }

    private TestGuiceyAppExtension(Config config) {
        this.config = config;
    }

    public static Builder forApp(Class<? extends Application> app) {
        return new Builder(app);
    }

    @Override
    protected DropwizardTestSupport<?> prepareTestSupport(ExtensionContext context) {
        if (this.config == null) {
            TestGuiceyApp ann = AnnotationSupport.findAnnotation((Optional)context.getElement(), TestGuiceyApp.class).orElse(null);
            Preconditions.checkNotNull((Object)ann, (String)"%s annotation not declared: can't work without configuration, so either use annotation or extension with @%s for manual configuration", (Object)TestGuiceyApp.class.getSimpleName(), (Object)RegisterExtension.class.getSimpleName());
            this.config = Config.parse(ann);
        }
        HooksUtil.register(this.config.hooks);
        String configPrefix = ConfigOverrideUtils.createPrefix(context.getRequiredTestClass());
        return this.create(this.config.app, this.config.configPath, configPrefix);
    }

    private <C extends Configuration> DropwizardTestSupport<C> create(Class<? extends Application> app, String configPath, String configPrefix) {
        return new GuiceyTestSupport(app, configPath, configPrefix, this.buildConfigOverrides(configPrefix));
    }

    private <T extends ConfigOverride> ConfigOverride[] buildConfigOverrides(String prefix) {
        ConfigOverride[] overrides = ConfigOverrideUtils.convert(prefix, this.config.configOverrides);
        return this.config.configOverrideObjects.isEmpty() ? overrides : ConfigOverrideUtils.merge(overrides, ConfigOverrideUtils.prepareOverrides(prefix, this.config.configOverrideObjects));
    }

    private static class Config {
        Class<? extends Application> app;
        String configPath = "";
        String[] configOverrides = new String[0];
        List<ConfigOverride> configOverrideObjects = new ArrayList<ConfigOverride>();
        List<GuiceyConfigurationHook> hooks;

        private Config() {
        }

        static Config parse(TestGuiceyApp ann) {
            Config res = new Config();
            res.app = ann.value();
            res.configPath = ann.config();
            res.configOverrides = ann.configOverride();
            res.hooks = HooksUtil.create(ann.hooks());
            return res;
        }
    }

    public static class Builder {
        private final Config cfg = new Config();

        public Builder(Class<? extends Application> app) {
            this.cfg.app = (Class)Preconditions.checkNotNull(app, (Object)"Application class must be provided");
        }

        public Builder config(String configPath) {
            this.cfg.configPath = configPath;
            return this;
        }

        public Builder configOverrides(String ... values) {
            this.cfg.configOverrides = values;
            return this;
        }

        @SafeVarargs
        public final <T extends ConfigOverride> Builder configOverrides(T ... values) {
            Collections.addAll(this.cfg.configOverrideObjects, values);
            return this;
        }

        public Builder configOverride(String key, Supplier<String> supplier) {
            this.configOverrides(new ConfigOverrideValue[]{new ConfigOverrideValue(key, supplier)});
            return this;
        }

        public Builder hooks(Class<? extends GuiceyConfigurationHook> hooks) {
            if (this.cfg.hooks == null) {
                this.cfg.hooks = HooksUtil.create(hooks);
            } else {
                this.cfg.hooks.addAll(HooksUtil.create(hooks));
            }
            return this;
        }

        public Builder hooks(GuiceyConfigurationHook ... hooks) {
            if (this.cfg.hooks == null) {
                this.cfg.hooks = new ArrayList<GuiceyConfigurationHook>();
            }
            Collections.addAll(this.cfg.hooks, hooks);
            return this;
        }

        public TestGuiceyAppExtension create() {
            return new TestGuiceyAppExtension(this.cfg);
        }
    }
}

