/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.google.common.base.Preconditions;
import io.dropwizard.Application;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import io.dropwizard.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.platform.commons.support.AnnotationSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.dropwizard.guice.test.jupiter.TestDropwizardApp;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.GuiceyExtensionsSupport;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideUtils;
import ru.vyarus.dropwizard.guice.test.util.ConfigOverrideValue;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;
import ru.vyarus.dropwizard.guice.test.util.RandomPortsListener;

public class TestDropwizardAppExtension
extends GuiceyExtensionsSupport {
    private static final String STAR = "*";
    private Config config;

    public TestDropwizardAppExtension() {
    }

    private TestDropwizardAppExtension(Config config) {
        this.config = config;
    }

    public static Builder forApp(Class<? extends Application> app) {
        return new Builder(app);
    }

    @Override
    protected DropwizardTestSupport<?> prepareTestSupport(ExtensionContext context) {
        if (this.config == null) {
            TestDropwizardApp ann = AnnotationSupport.findAnnotation((Optional)context.getElement(), TestDropwizardApp.class).orElse(null);
            Preconditions.checkNotNull((Object)ann, (String)"%s annotation not declared: can't work without configuration, so either use annotation or extension with @%s for manual configuration", (Object)TestDropwizardApp.class.getSimpleName(), (Object)RegisterExtension.class.getSimpleName());
            this.config = Config.parse(ann);
        }
        HooksUtil.register(this.config.hooks);
        String configPrefix = ConfigOverrideUtils.createPrefix(context.getRequiredTestClass());
        DropwizardTestSupport support = new DropwizardTestSupport(this.config.app, this.config.configPath, configPrefix, this.buildConfigOverrides(configPrefix));
        if (this.config.randomPorts) {
            support.addListener((DropwizardTestSupport.ServiceListener)new RandomPortsListener());
        }
        return support;
    }

    private <T extends ConfigOverride> ConfigOverride[] buildConfigOverrides(String prefix) {
        ConfigOverride[] overrides = ConfigOverrideUtils.convert(prefix, this.config.configOverrides);
        if (!Strings.isNullOrEmpty((String)this.config.restMapping)) {
            String mapping = PathUtils.leadingSlash(this.config.restMapping);
            if (!mapping.endsWith(STAR)) {
                mapping = PathUtils.trailingSlash(mapping) + STAR;
            }
            overrides = ConfigOverrideUtils.merge(overrides, ConfigOverride.config((String)prefix, (String)"server.rootPath", (String)mapping));
        }
        return this.config.configOverrideObjects.isEmpty() ? overrides : ConfigOverrideUtils.merge(overrides, ConfigOverrideUtils.prepareOverrides(prefix, this.config.configOverrideObjects));
    }

    private static class Config {
        Class<? extends Application> app;
        String configPath = "";
        String[] configOverrides = new String[0];
        List<ConfigOverride> configOverrideObjects = new ArrayList<ConfigOverride>();
        List<GuiceyConfigurationHook> hooks;
        boolean randomPorts;
        String restMapping = "";

        private Config() {
        }

        static Config parse(TestDropwizardApp ann) {
            Config res = new Config();
            res.app = ann.value();
            res.configPath = ann.config();
            res.configOverrides = ann.configOverride();
            res.hooks = HooksUtil.create(ann.hooks());
            res.randomPorts = ann.randomPorts();
            res.restMapping = ann.restMapping();
            return res;
        }
    }

    public static class Builder {
        private final Config cfg = new Config();

        public Builder(Class<? extends Application> app) {
            this.cfg.app = (Class)Preconditions.checkNotNull(app, (Object)"Application class must be provided");
        }

        public Builder config(String configPath) {
            this.cfg.configPath = configPath;
            return this;
        }

        public Builder configOverrides(String ... values) {
            this.cfg.configOverrides = values;
            return this;
        }

        @SafeVarargs
        public final <T extends ConfigOverride> Builder configOverrides(T ... values) {
            Collections.addAll(this.cfg.configOverrideObjects, values);
            return this;
        }

        public Builder configOverride(String key, Supplier<String> supplier) {
            this.configOverrides(new ConfigOverrideValue[]{new ConfigOverrideValue(key, supplier)});
            return this;
        }

        public Builder hooks(Class<? extends GuiceyConfigurationHook> hooks) {
            if (this.cfg.hooks == null) {
                this.cfg.hooks = HooksUtil.create(hooks);
            } else {
                this.cfg.hooks.addAll(HooksUtil.create(hooks));
            }
            return this;
        }

        public Builder hooks(GuiceyConfigurationHook ... hooks) {
            if (this.cfg.hooks == null) {
                this.cfg.hooks = new ArrayList<GuiceyConfigurationHook>();
            }
            Collections.addAll(this.cfg.hooks, hooks);
            return this;
        }

        public Builder randomPorts(boolean randomPorts) {
            this.cfg.randomPorts = randomPorts;
            return this;
        }

        public Builder randomPorts() {
            return this.randomPorts(true);
        }

        public Builder restMapping(String mapping) {
            this.cfg.restMapping = mapping;
            return this;
        }

        public TestDropwizardAppExtension create() {
            return new TestDropwizardAppExtension(this.cfg);
        }
    }
}

