/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import io.dropwizard.testing.DropwizardTestSupport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.EnableHook;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.TestParametersSupport;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;

public abstract class GuiceyExtensionsSupport
extends TestParametersSupport
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback {
    private static final String DW_SUPPORT = "DW_SUPPORT";
    private static final String DW_CLIENT = "DW_CLIENT";
    private static final String INHERITED_DW_SUPPORT = "INHERITED_DW_SUPPORT";

    public void beforeAll(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = GuiceyExtensionsSupport.getExtensionStore(context);
        if (store.get((Object)DW_SUPPORT) == null) {
            HookFields hooks = new HookFields(context.getRequiredTestClass());
            hooks.activateBaseHooks();
            DropwizardTestSupport<?> support = this.prepareTestSupport(context);
            hooks.activateClassHooks();
            store.put((Object)DW_SUPPORT, support);
            store.put((Object)DW_CLIENT, (Object)new ClientSupport(support));
            support.before();
        } else {
            ExtensionContext.Store localStore = this.getLocalExtensionStore(context);
            Preconditions.checkState((localStore.get((Object)INHERITED_DW_SUPPORT) == null ? 1 : 0) != 0, (Object)"Storage assumptions were wrong or unexpected junit usage appear. Please report this case to guicey developer.");
            localStore.put((Object)INHERITED_DW_SUPPORT, (Object)true);
        }
    }

    public void beforeEach(ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElseThrow(() -> new IllegalStateException("Unable to get the current test instance"));
        DropwizardTestSupport support = (DropwizardTestSupport)Preconditions.checkNotNull(this.getSupport(context), (Object)"Guicey test support was not initialized: most likely, you are trying to manually register extension using non-static field - such usage is not supported.");
        InjectorLookup.getInjector(support.getApplication()).orElseThrow(() -> new IllegalStateException("Can't find guicey injector to process test fields injections")).injectMembers(testInstance);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ClientSupport client;
        ConfigurationHooksSupport.reset();
        ExtensionContext.Store localExtensionStore = this.getLocalExtensionStore(context);
        if (localExtensionStore.get((Object)INHERITED_DW_SUPPORT) != null) {
            localExtensionStore.remove((Object)INHERITED_DW_SUPPORT);
            return;
        }
        DropwizardTestSupport<?> support = this.getSupport(context);
        if (support != null) {
            support.after();
        }
        if ((client = this.getClient(context)) != null) {
            client.close();
        }
    }

    public static Optional<DropwizardTestSupport<?>> lookupSupport(ExtensionContext extensionContext) {
        return Optional.ofNullable((DropwizardTestSupport)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_SUPPORT));
    }

    public static Optional<Injector> lookupInjector(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupSupport(extensionContext).flatMap(it -> InjectorLookup.getInjector(it.getApplication()));
    }

    public static Optional<ClientSupport> lookupClient(ExtensionContext extensionContext) {
        return Optional.ofNullable((ClientSupport)GuiceyExtensionsSupport.getExtensionStore(extensionContext).get((Object)DW_CLIENT));
    }

    protected abstract DropwizardTestSupport<?> prepareTestSupport(ExtensionContext var1);

    @Override
    protected DropwizardTestSupport<?> getSupport(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupSupport(extensionContext).orElse(null);
    }

    @Override
    protected ClientSupport getClient(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupClient(extensionContext).orElse(null);
    }

    @Override
    protected Optional<Injector> getInjector(ExtensionContext extensionContext) {
        return GuiceyExtensionsSupport.lookupInjector(extensionContext);
    }

    protected static ExtensionContext.Store getExtensionStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class}));
    }

    private ExtensionContext.Store getLocalExtensionStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{GuiceyExtensionsSupport.class, context.getRequiredTestClass()}));
    }

    private static class HookFields {
        private final Class<?> testClass;
        private final List<Field> fields;

        HookFields(Class<?> testClass) {
            this.testClass = testClass;
            this.fields = this.findHookFields(testClass);
        }

        public void activateBaseHooks() {
            this.activateFieldHooks(field -> !this.testClass.equals(field.getDeclaringClass()));
        }

        public void activateClassHooks() {
            this.activateFieldHooks(null);
        }

        private void activateFieldHooks(Predicate<Field> condition) {
            if (!this.fields.isEmpty()) {
                List<Field> target;
                if (condition != null) {
                    target = this.fields.stream().filter(condition).collect(Collectors.toList());
                    this.fields.removeAll(target);
                } else {
                    target = this.fields;
                }
                HooksUtil.register(ReflectionUtils.readFieldValues(target, null));
            }
        }

        private List<Field> findHookFields(Class<?> testClass) {
            List fields = AnnotationSupport.findAnnotatedFields(testClass, EnableHook.class);
            HooksUtil.validateFieldHooks(fields);
            return fields.isEmpty() ? Collections.emptyList() : new ArrayList(fields);
        }
    }
}

