/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.binder.ScopedBindingBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.Custom;
import org.glassfish.jersey.internal.inject.CustomAnnotationLiteral;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.GuiceManaged;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.JerseyManaged;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.jersey.support.GuiceComponentFactory;
import ru.vyarus.dropwizard.guice.module.jersey.support.JerseyComponentProvider;
import ru.vyarus.dropwizard.guice.module.jersey.support.LazyGuiceFactory;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.GenericsContext;
import ru.vyarus.java.generics.resolver.context.container.ParameterizedTypeImpl;

public final class JerseyBinding {
    private JerseyBinding() {
    }

    public static boolean isBridgeAvailable() {
        try {
            Class.forName("org.jvnet.hk2.guice.bridge.api.GuiceBridge");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isJerseyManaged(Class<?> type, boolean guiceFirstMode) {
        return guiceFirstMode ? type.isAnnotationPresent(JerseyManaged.class) : !type.isAnnotationPresent(GuiceManaged.class);
    }

    public static void bindComponent(AbstractBinder binder, Injector injector, Class<?> type, boolean jerseyManaged, boolean singleton) {
        if (jerseyManaged) {
            JerseyBinding.optionalSingleton(binder.bindAsContract(type), singleton);
        } else {
            JerseyBinding.optionalSingleton(JerseyBinding.prioritize(binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type), false, type), singleton);
        }
    }

    public static <T> void bindFactory(AbstractBinder binder, Injector injector, Class<?> type, boolean jerseyManaged, boolean singleton) {
        Class res = GenericsResolver.resolve(type, (Class[])new Class[0]).type(Supplier.class).generic(0);
        if (jerseyManaged) {
            JerseyBinding.optionalSingleton(singleton ? ((SupplierClassBinding)binder.bindFactory(type, Singleton.class).to(type)).to((Type)res) : ((SupplierClassBinding)binder.bindFactory(type).to(type)).to((Type)res), singleton);
        } else {
            binder.bindFactory(new LazyGuiceFactory(injector, type)).to(res);
            JerseyBinding.optionalSingleton(binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type), singleton);
        }
    }

    public static void bindSpecificComponent(AbstractBinder binder, Injector injector, Class<?> type, Class<?> specificType, boolean jerseyManaged, boolean singleton, boolean autoQualify) {
        ParameterizedTypeImpl bindingType;
        GenericsContext context = GenericsResolver.resolve(type, (Class[])new Class[0]).type(specificType);
        List genericTypes = context.genericTypes();
        Type[] generics = genericTypes.toArray(new Type[0]);
        ParameterizedTypeImpl parameterizedTypeImpl = bindingType = generics.length > 0 ? new ParameterizedTypeImpl((Type)specificType, generics) : specificType;
        if (jerseyManaged) {
            JerseyBinding.optionalSingleton(((ClassBinding)binder.bind(type).to(type)).to((Type)bindingType), singleton);
        } else {
            JerseyBinding.optionalSingleton(JerseyBinding.prioritize(((SupplierInstanceBinding)binder.bindFactory(new GuiceComponentFactory(injector, type)).to(type)).to((Type)bindingType), autoQualify, type), singleton);
        }
    }

    public static <T> ScopedBindingBuilder bindJerseyComponent(Binder binder, Provider<Injector> provider, Class<T> type) {
        return binder.bind(type).toProvider(new JerseyComponentProvider<T>(provider, type));
    }

    private static Binding<?, ?> prioritize(Binding<?, ?> binding, boolean autoQualify, Class<?> type) {
        Priority priority;
        if (autoQualify || FeatureUtils.hasAnnotation(type, Custom.class)) {
            binding.qualifiedBy((Annotation)CustomAnnotationLiteral.INSTANCE);
        }
        if ((priority = FeatureUtils.getAnnotation(type, Priority.class)) != null) {
            binding.ranked(priority.value());
        }
        return binding;
    }

    private static void optionalSingleton(Binding<?, ?> binding, boolean singleton) {
        if (singleton) {
            binding.in(Singleton.class);
        }
    }
}

