/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.web.listener;

import com.google.common.collect.ImmutableList;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import java.util.EventListener;
import java.util.List;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.AdminContext;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.listener.ListenerReporter;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.listener.SessionListenersSupport;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.util.WebUtils;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.option.InstallerOptionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

@Order(value=110)
public class WebListenerInstaller
extends InstallerOptionsSupport
implements FeatureInstaller,
InstanceInstaller<EventListener>,
Ordered {
    private static final List<Class<? extends EventListener>> CONTEXT_LISTENERS = ImmutableList.of(ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class);
    private static final List<Class<? extends EventListener>> SESSION_LISTENERS = ImmutableList.of(HttpSessionListener.class, HttpSessionAttributeListener.class, HttpSessionIdListener.class);
    private static final List<Class<? extends EventListener>> SUPPORTED = ImmutableList.builder().addAll(CONTEXT_LISTENERS).addAll(SESSION_LISTENERS).build();
    private final ListenerReporter reporter = new ListenerReporter();
    private SessionListenersSupport support;

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, EventListener.class) && FeatureUtils.hasAnnotation(type, WebListener.class) && this.hasMatch(type, SUPPORTED);
    }

    @Override
    public void install(Environment environment, EventListener instance) {
        Class<EventListener> extType = FeatureUtils.getInstanceClass(instance);
        boolean isContextListener = this.hasMatch(extType, CONTEXT_LISTENERS);
        boolean isSessionListener = this.hasMatch(extType, SESSION_LISTENERS);
        AdminContext context = FeatureUtils.getAnnotation(extType, AdminContext.class);
        this.reporter.listener(extType, WebUtils.getContextMarkers(context));
        if (isSessionListener && this.support == null) {
            this.support = new SessionListenersSupport((Boolean)this.option(InstallersOptions.DenySessionListenersWithoutSession));
            environment.lifecycle().manage((Managed)this.support);
        }
        if (WebUtils.isForMain(context)) {
            this.configure(environment.getApplicationContext(), instance, isContextListener, isSessionListener);
        }
        if (WebUtils.isForAdmin(context)) {
            this.configure(environment.getAdminContext(), instance, isContextListener, isSessionListener);
        }
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    private void configure(MutableServletContextHandler environment, EventListener listener, boolean context, boolean session) {
        if (session) {
            this.support.add(environment, listener);
        }
        if (context) {
            environment.addEventListener(listener);
        }
    }

    private boolean hasMatch(Class<?> type, List<Class<? extends EventListener>> types) {
        boolean res = false;
        for (Class<? extends EventListener> listenerType : types) {
            if (!listenerType.isAssignableFrom(type)) continue;
            res = true;
            break;
        }
        return res;
    }
}

