/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.plugin;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.plugin.Plugin;
import ru.vyarus.dropwizard.guice.module.installer.feature.plugin.PluginReporter;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

@Order(value=80)
public class PluginInstaller
implements FeatureInstaller,
BindingInstaller {
    private final PluginReporter reporter = new PluginReporter();

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.hasAnnotation(type, Plugin.class) || FeatureUtils.hasAnnotatedAnnotation(type, Plugin.class);
    }

    @Override
    public void bind(Binder binder, Class<?> type, boolean lazy) {
        Preconditions.checkArgument((!lazy ? 1 : 0) != 0, (String)"Plugin bean can't be lazy: %s", (Object)type.getName());
        this.registerPlugin(binder, type);
    }

    @Override
    public <T> void manualBinding(Binder binder, Class<T> type, Binding<T> binding) {
        this.registerPlugin(binder, type);
    }

    public void registerPlugin(Binder binder, Class<?> type) {
        Plugin annotation = FeatureUtils.getAnnotation(type, Plugin.class);
        if (annotation != null) {
            Class<?> pluginType = annotation.value();
            this.reporter.simple(pluginType, type);
            Multibinder.newSetBinder((Binder)binder, pluginType).addBinding().to(type);
        } else {
            Annotation namesAnnotation = FeatureUtils.getAnnotatedAnnotation(type, Plugin.class);
            Method valueMethod = FeatureUtils.findMethod(namesAnnotation.annotationType(), "value", new Class[0]);
            Class<?> keyType = valueMethod.getReturnType();
            Object key = FeatureUtils.invokeMethod(valueMethod, namesAnnotation, new Object[0]);
            Plugin pluginAnnotation = namesAnnotation.annotationType().getAnnotation(Plugin.class);
            Class<?> pluginType = pluginAnnotation.value();
            this.reporter.named(keyType, pluginType, key, type);
            this.registerNamedPlugin(binder, pluginType, keyType, type, key);
        }
    }

    private <T, K> void registerNamedPlugin(Binder binder, Class<T> pluginType, Class<K> keyType, Class<? extends T> plugin, K key) {
        MapBinder.newMapBinder((Binder)binder, keyType, pluginType).addBinding(key).to(plugin);
    }

    @Override
    public void report() {
        this.reporter.report();
    }
}

