/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ExtensionItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;

public class InstallerModule
extends AbstractModule {
    private final ConfigurationContext context;

    public InstallerModule(ConfigurationContext context) {
        this.context = context;
    }

    protected void configure() {
        this.bind(ExtensionsHolder.class).toInstance((Object)this.context.getExtensionsHolder());
        for (ExtensionItemInfoImpl ext : this.context.getExtensionsHolder().getExtensionsData()) {
            this.bindExtension(ext, ext.getInstaller(), ext.getManualBinding());
        }
    }

    private void bindExtension(ExtensionItemInfo item, FeatureInstaller installer, Binding manualBinding) {
        Class<?> type = item.getType();
        if (installer instanceof BindingInstaller) {
            BindingInstaller bindingInstaller = (BindingInstaller)((Object)installer);
            if (manualBinding != null) {
                bindingInstaller.manualBinding(this.binder(), type, manualBinding);
            } else {
                bindingInstaller.bind(this.binder(), type, item.isLazy());
            }
            bindingInstaller.extensionBound(this.binder().currentStage(), type);
        } else if (manualBinding == null && !item.isLazy()) {
            this.binder().bind(type);
        }
    }
}

