/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.stat;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import java.util.Map;
import ru.vyarus.dropwizard.guice.module.context.stat.GuiceStatsTracker;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;

public final class StatsTracker {
    private final Map<Stat, Stopwatch> timers = Maps.newEnumMap(Stat.class);
    private final Map<Stat, Integer> counters = Maps.newEnumMap(Stat.class);
    private final GuiceStatsTracker guiceStats = new GuiceStatsTracker();

    public Stopwatch timer(Stat name) {
        Stopwatch watch = this.timers.computeIfAbsent(name, k -> Stopwatch.createUnstarted());
        watch.start();
        return watch;
    }

    public void count(Stat name, int count) {
        Integer value = this.counters.get((Object)name);
        value = value == null ? count : value + count;
        this.counters.put(name, value);
    }

    public void startJerseyTimer(Stat name) {
        this.timer(Stat.GuiceyTime);
        if (!Stat.JerseyTime.equals((Object)name)) {
            this.timer(Stat.JerseyTime);
        }
        this.timer(name);
    }

    public void stopJerseyTimer(Stat name) {
        this.timers.get((Object)Stat.GuiceyTime).stop();
        if (!Stat.JerseyTime.equals((Object)name)) {
            this.timers.get((Object)Stat.JerseyTime).stop();
        }
        this.timers.get((Object)name).stop();
    }

    public Map<Stat, Stopwatch> getTimers() {
        return this.timers;
    }

    public Map<Stat, Integer> getCounters() {
        return this.counters;
    }

    public GuiceStatsTracker getGuiceStats() {
        return this.guiceStats;
    }
}

