/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.option.mapper;

import com.google.common.base.Splitter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.StreamSupport;

public final class StringConverter {
    private StringConverter() {
    }

    public static <V> V convert(Class<V> target, String value) {
        Object res = target.isArray() ? StringConverter.handleArray(target.getComponentType(), value) : (target == EnumSet.class ? StringConverter.handleEnumSet(value) : StringConverter.convertSimple(target, value));
        return (V)res;
    }

    private static <V> V[] handleArray(Class<V> type, String value) {
        try {
            return StreamSupport.stream(Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)value).spliterator(), false).map(val -> StringConverter.convertSimple(type, val)).toArray(num -> (Object[])Array.newInstance(type, num));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to parse array " + type.getSimpleName() + "[] from: " + value, ex);
        }
    }

    private static EnumSet handleEnumSet(String value) {
        try {
            return EnumSet.copyOf(Arrays.asList(StringConverter.handleArray(Enum.class, value)));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to parse EnumSet from: " + value, ex);
        }
    }

    private static <V> V convertSimple(Class<V> type, String value) {
        Object res = null;
        try {
            if (type == String.class) {
                res = value;
            } else if (type == Boolean.class) {
                res = Boolean.valueOf(value);
            } else if (type == Integer.class) {
                res = Integer.valueOf(value);
            } else if (type == Double.class) {
                res = Double.valueOf(value);
            } else if (type == Short.class) {
                res = Short.valueOf(value);
            } else if (type == Byte.class) {
                res = Byte.valueOf(value);
            } else if (type.isEnum()) {
                res = Enum.valueOf(type, value);
            } else if (type == Enum.class) {
                res = StringConverter.parseEnum(value);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Failed to convert value '%s' to %s", value, type.getName()), ex);
        }
        if (res == null) {
            throw new IllegalStateException(String.format("Can't convert value '%s': unsupported target type %s", value, type.getName()));
        }
        return (V)res;
    }

    private static Enum parseEnum(String value) {
        int idx = value.lastIndexOf(46);
        try {
            Class<?> type = Class.forName(value.substring(0, idx));
            if (!type.isEnum()) {
                throw new IllegalStateException("Type " + type.getName() + " is not enum");
            }
            return Enum.valueOf(type, value.substring(idx + 1));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to recognize enum value: " + value, ex);
        }
    }
}

