/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.option;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.module.context.option.internal.OptionHolder;
import ru.vyarus.dropwizard.guice.module.context.option.internal.OptionsSupport;

public final class OptionsInfo {
    private final OptionsSupport options;

    public OptionsInfo(OptionsSupport support) {
        this.options = support;
    }

    public <T extends Enum> Set<T> getOptions() {
        return this.options.getOptions();
    }

    public List<Class<Enum>> getOptionGroups() {
        return this.getOptions().stream().map(rec$ -> ((Enum)rec$).getDeclaringClass()).distinct().sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.toList());
    }

    public <V> V getValue(Enum option) {
        OptionHolder holder = this.options.getHolder(option);
        return holder == null ? null : (V)holder.getValue();
    }

    public boolean isUsed(Enum option) {
        OptionHolder holder = this.options.getHolder(option);
        return holder != null && holder.isUsed();
    }

    public boolean isSet(Enum option) {
        OptionHolder holder = this.options.getHolder(option);
        return holder != null && holder.isSet();
    }

    public boolean knowsOption(Enum option) {
        return this.options.containsOption(option);
    }
}

