/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice.model;

import com.google.inject.servlet.InstanceFilterBinding;
import com.google.inject.servlet.InstanceServletBinding;
import com.google.inject.servlet.LinkedFilterBinding;
import com.google.inject.servlet.LinkedServletBinding;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.Element;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.InterceptorBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProvisionListenerBinding;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeListenerBinding;
import com.google.inject.spi.UntargettedBinding;

public enum DeclarationType {
    Scope(ScopeBinding.class, false),
    Instance(InstanceBinding.class, true),
    ProviderInstance(ProviderInstanceBinding.class, true),
    LinkedKey(LinkedKeyBinding.class, true),
    ProviderKey(ProviderKeyBinding.class, true),
    Untargetted(UntargettedBinding.class, true),
    Aop(InterceptorBinding.class, false),
    TypeListener(TypeListenerBinding.class, false),
    ProvisionListener(ProvisionListenerBinding.class, false),
    TypeConverter(TypeConverterBinding.class, false),
    ProviderMethod(ModuleAnnotatedMethodScannerBinding.class, true),
    Exposed(ExposedBinding.class, true),
    FilterKey(LinkedFilterBinding.class, false),
    FilterInstance(InstanceFilterBinding.class, false),
    ServletKey(LinkedServletBinding.class, false),
    ServletInstance(InstanceServletBinding.class, false),
    Binding(ConstructorBinding.class, true),
    ConvertedConstant(ConvertedConstantBinding.class, true);

    private final Class<?> type;
    private final boolean runtimeBinding;

    private DeclarationType(Class<?> type, boolean runtimeBinding) {
        this.type = type;
        this.runtimeBinding = runtimeBinding;
    }

    public boolean isRuntimeBinding() {
        return this.runtimeBinding;
    }

    public Class<?> getType() {
        return this.type;
    }

    public static DeclarationType detect(Class<? extends Element> type) {
        for (DeclarationType dec : DeclarationType.values()) {
            if (!dec.type.isAssignableFrom(type)) continue;
            return dec;
        }
        return null;
    }
}

