/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import ru.stqa.selenium.factory.AbstractWebDriverPool;

public final class ThreadLocalSingleWebDriverPool
extends AbstractWebDriverPool {
    private ThreadLocal<WebDriver> tlDriver = new ThreadLocal();
    private Map<WebDriver, String> driverToKeyMap = new HashMap<WebDriver, String>();

    public ThreadLocalSingleWebDriverPool() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ThreadLocalSingleWebDriverPool.this.dismissAll();
            }
        });
    }

    @Override
    public WebDriver getDriver(String hub, Capabilities capabilities) {
        String newKey = this.createKey(capabilities, hub);
        if (this.tlDriver.get() == null) {
            this.createNewDriver(capabilities, hub);
        } else {
            String key = this.driverToKeyMap.get(this.tlDriver.get());
            if (key == null) {
                this.createNewDriver(capabilities, hub);
            } else if (!newKey.equals(key)) {
                this.dismissDriver(this.tlDriver.get());
                this.createNewDriver(capabilities, hub);
            } else if (!this.alivenessChecker.isAlive(this.tlDriver.get())) {
                this.dismissDriver(this.tlDriver.get());
                this.createNewDriver(capabilities, hub);
            }
        }
        return this.tlDriver.get();
    }

    @Override
    public void dismissDriver(WebDriver driver) {
        if (this.driverToKeyMap.get(driver) == null) {
            throw new Error("The driver is not owned by the factory: " + driver);
        }
        if (driver != this.tlDriver.get()) {
            throw new Error("The driver does not belong to the current thread: " + driver);
        }
        driver.quit();
        this.driverToKeyMap.remove(driver);
        this.tlDriver.remove();
    }

    @Override
    public void dismissAll() {
        for (WebDriver driver : new HashSet<WebDriver>(this.driverToKeyMap.keySet())) {
            driver.quit();
            this.driverToKeyMap.remove(driver);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.driverToKeyMap.isEmpty();
    }

    private void createNewDriver(Capabilities capabilities, String hub) {
        String newKey = this.createKey(capabilities, hub);
        WebDriver driver = this.newDriver(hub, capabilities);
        this.driverToKeyMap.put(driver, newKey);
        this.tlDriver.set(driver);
    }
}

