/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import ru.stqa.selenium.factory.AbstractWebDriverPool;

public final class SingleWebDriverPool
extends AbstractWebDriverPool {
    private String key;
    private WebDriver driver;

    public SingleWebDriverPool() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SingleWebDriverPool.this.dismissAll();
            }
        });
    }

    @Override
    public WebDriver getDriver(String hub, Capabilities capabilities) {
        String newKey = this.createKey(capabilities, hub);
        if (this.driver == null) {
            this.createNewDriver(hub, capabilities);
        } else if (!newKey.equals(this.key)) {
            this.dismissDriver();
            this.createNewDriver(hub, capabilities);
        } else if (!this.alivenessChecker.isAlive(this.driver)) {
            this.createNewDriver(hub, capabilities);
        }
        return this.driver;
    }

    @Override
    public void dismissDriver(WebDriver driver) {
        if (driver != this.driver) {
            throw new Error("The driver is not owned by the factory: " + driver);
        }
        this.dismissDriver();
    }

    @Override
    public void dismissAll() {
        this.dismissDriver();
    }

    @Override
    public boolean isEmpty() {
        return this.driver == null;
    }

    private void createNewDriver(String hub, Capabilities capabilities) {
        String newKey = this.createKey(capabilities, hub);
        this.driver = this.newDriver(hub, capabilities);
        this.key = newKey;
    }

    private void dismissDriver() {
        if (this.driver != null) {
            this.driver.quit();
            this.driver = null;
            this.key = null;
        }
    }
}

