/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import ru.stqa.selenium.factory.LocalDriverProvider;

public class ReflectionBasedLocalDriverProvider
implements LocalDriverProvider {
    private static final Logger LOG = Logger.getLogger(ReflectionBasedLocalDriverProvider.class.getName());
    private Capabilities capabilities;
    private Class<? extends WebDriver> driverClass;
    private String driverClassName;

    public ReflectionBasedLocalDriverProvider(Capabilities capabilities, Class<? extends WebDriver> driverClass) {
        this.capabilities = new DesiredCapabilities(capabilities);
        this.driverClass = driverClass;
    }

    public ReflectionBasedLocalDriverProvider(Capabilities capabilities, String driverClassName) {
        this.capabilities = new DesiredCapabilities(capabilities);
        this.driverClassName = driverClassName;
    }

    private Class<? extends WebDriver> getDriverClass() {
        if (this.driverClass != null) {
            return this.driverClass;
        }
        try {
            return Class.forName(this.driverClassName).asSubclass(WebDriver.class);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.INFO, "Driver class not found: " + this.driverClassName);
            return null;
        }
        catch (NoClassDefFoundError e) {
            LOG.log(Level.INFO, "Driver class not found: " + this.driverClassName);
            return null;
        }
        catch (UnsupportedClassVersionError e) {
            LOG.log(Level.INFO, "Driver class is built for higher Java version: " + this.driverClassName);
            return null;
        }
    }

    @Override
    public boolean canCreateDriverInstanceFor(Capabilities capabilities) {
        return this.capabilities.getBrowserName().equals(capabilities.getBrowserName());
    }

    @Override
    public WebDriver createDriver(Capabilities capabilities) {
        if (this.canCreateDriverInstanceFor(capabilities)) {
            return this.callConstructor(this.getDriverClass(), capabilities);
        }
        return null;
    }

    private WebDriver callConstructor(Class<? extends WebDriver> from, Capabilities capabilities) {
        try {
            Constructor<? extends WebDriver> constructor = from.getConstructor(Capabilities.class);
            return constructor.newInstance(capabilities);
        }
        catch (NoSuchMethodException e) {
            try {
                return from.newInstance();
            }
            catch (InstantiationException e1) {
                throw new WebDriverException((Throwable)e);
            }
            catch (IllegalAccessException e1) {
                throw new WebDriverException((Throwable)e);
            }
        }
        catch (InvocationTargetException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

