/*
 * Decompiled with CFR 0.152.
 */
package ru.stqa.selenium.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import ru.stqa.selenium.factory.DefaultDriverAlivenessChecker;
import ru.stqa.selenium.factory.DriverAlivenessChecker;
import ru.stqa.selenium.factory.LocalDriverProvider;
import ru.stqa.selenium.factory.ReflectionBasedLocalDriverProvider;
import ru.stqa.selenium.factory.ReflectionBasedRemoteDriverProvider;
import ru.stqa.selenium.factory.RemoteDriverProvider;
import ru.stqa.selenium.factory.WebDriverPool;

public abstract class AbstractWebDriverPool
implements WebDriverPool {
    private String defaultHub = null;
    protected DriverAlivenessChecker alivenessChecker = new DefaultDriverAlivenessChecker();
    private List<LocalDriverProvider> localDriverProviders = new ArrayList<LocalDriverProvider>();
    private List<RemoteDriverProvider> remoteDriverProviders;

    public AbstractWebDriverPool() {
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.chrome(), "org.openqa.selenium.chrome.ChromeDriver"));
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.firefox(), "org.openqa.selenium.firefox.FirefoxDriver"));
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.internetExplorer(), "org.openqa.selenium.ie.InternetExplorerDriver"));
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.edge(), "org.openqa.selenium.edge.EdgeDriver"));
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.operaBlink(), "org.openqa.selenium.opera.OperaDriver"));
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.opera(), "com.opera.core.systems.OperaDriver"));
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.safari(), "org.openqa.selenium.safari.SafariDriver"));
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.phantomjs(), "org.openqa.selenium.phantomjs.PhantomJSDriver"));
        this.localDriverProviders.add(new ReflectionBasedLocalDriverProvider((Capabilities)DesiredCapabilities.htmlUnit(), "org.openqa.selenium.htmlunit.HtmlUnitDriver"));
        for (LocalDriverProvider localDriverProvider : ServiceLoader.load(LocalDriverProvider.class)) {
            this.localDriverProviders.add(localDriverProvider);
        }
        this.remoteDriverProviders = new ArrayList<RemoteDriverProvider>();
        this.remoteDriverProviders.add(new ReflectionBasedRemoteDriverProvider());
        for (RemoteDriverProvider remoteDriverProvider : ServiceLoader.load(RemoteDriverProvider.class)) {
            this.remoteDriverProviders.add(remoteDriverProvider);
        }
    }

    @Override
    public void addLocalDriverProvider(LocalDriverProvider provider) {
        this.localDriverProviders.add(0, provider);
    }

    @Override
    public void addRemoteDriverProvider(RemoteDriverProvider provider) {
        this.remoteDriverProviders.add(0, provider);
    }

    @Override
    public void setDefaultHub(String defaultHub) {
        this.defaultHub = defaultHub;
    }

    @Override
    public WebDriver getDriver(Capabilities capabilities) {
        return this.getDriver(this.defaultHub, capabilities);
    }

    protected String createKey(Capabilities capabilities, String hub) {
        return capabilities.toString() + ":" + hub;
    }

    protected WebDriver newDriver(String hub, Capabilities capabilities) {
        return hub == null ? this.createLocalDriver(capabilities) : this.createRemoteDriver(hub, capabilities);
    }

    private WebDriver createLocalDriver(Capabilities capabilities) {
        for (LocalDriverProvider provider : this.localDriverProviders) {
            WebDriver driver = provider.createDriver(capabilities);
            if (driver == null) continue;
            return driver;
        }
        throw new Error("Can't find local driver provider for capabilities " + capabilities);
    }

    private WebDriver createRemoteDriver(String hub, Capabilities capabilities) {
        for (RemoteDriverProvider provider : this.remoteDriverProviders) {
            WebDriver driver = provider.createDriver(hub, capabilities);
            if (driver == null) continue;
            return driver;
        }
        throw new Error("Can't find remote driver provider for capabilities " + capabilities);
    }

    @Override
    public void setDriverAlivenessChecker(DriverAlivenessChecker alivenessChecker) {
        this.alivenessChecker = alivenessChecker;
    }
}

