/*
 * Decompiled with CFR 0.152.
 */
package ru.starksoft.simplemessage;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.starksoft.simplemessage.Message;
import ru.starksoft.simplemessage.MessageData;
import ru.starksoft.simplemessage.MessageTemplate;
import ru.starksoft.simplemessage.MessageType;
import ru.starksoft.simplemessage.SimpleMessage$Builder$WhenMappings;
import ru.starksoft.simplemessage.SimpleMessage$WhenMappings;
import ru.starksoft.simplemessage.SimpleMessageManager;
import ru.starksoft.simplemessage.StatusBarMessageLayout;
import ru.starksoft.simplemessage.ToolBarMessageLayout;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\u0006\u0010\r\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/starksoft/simplemessage/SimpleMessage;", "", "activity", "Landroid/app/Activity;", "messageData", "Lru/starksoft/simplemessage/MessageData;", "(Landroid/app/Activity;Lru/starksoft/simplemessage/MessageData;)V", "view", "Lru/starksoft/simplemessage/Message;", "getMessageImplByType", "hide", "", "observeLifecycle", "show", "Builder", "Companion", "simple-message_release"})
public final class SimpleMessage {
    private final Activity activity;
    private final Message view;
    private static final String TAG = "SimpleMessage";
    public static final Companion Companion = new Companion(null);

    private final void observeLifecycle() {
        if (this.activity instanceof AppCompatActivity) {
            ((AppCompatActivity)this.activity).getLifecycle().addObserver(new LifecycleObserver(){

                @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                public final void destroy() {
                    SimpleMessageManager.Companion.getInstance().destroy();
                    Log.d((String)"SimpleMessage", (String)"destroy() called");
                }
            });
        }
    }

    public final void show() {
        this.view.show();
    }

    public final void hide() {
        this.view.hide();
    }

    private final Message getMessageImplByType(Activity activity, MessageData messageData) {
        Message message;
        switch (SimpleMessage$WhenMappings.$EnumSwitchMapping$0[messageData.getMessageType().ordinal()]) {
            case 1: {
                message = new StatusBarMessageLayout((Context)activity, messageData);
                break;
            }
            case 2: {
                message = new ToolBarMessageLayout((Context)activity, messageData);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return message;
    }

    private SimpleMessage(Activity activity, MessageData messageData) {
        Activity activity2;
        SimpleMessage simpleMessage = this;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (activity == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        simpleMessage.activity = activity2 = activity;
        this.view = this.getMessageImplByType(activity, messageData);
        this.observeLifecycle();
    }

    public /* synthetic */ SimpleMessage(Activity activity, MessageData messageData, DefaultConstructorMarker $constructor_marker) {
        this(activity, messageData);
    }

    @JvmStatic
    @NotNull
    public static final Builder create(@NotNull Activity activity, @NotNull CharSequence message) {
        return Companion.create(activity, message);
    }

    @JvmStatic
    @NotNull
    public static final Builder create(@NotNull Activity activity, @NotNull CharSequence message, @Nullable MessageTemplate template) {
        return Companion.create(activity, message, template);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00002\b\b\u0001\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00002\b\b\u0001\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/starksoft/simplemessage/SimpleMessage$Builder;", "", "activity", "Landroid/app/Activity;", "message", "", "template", "Lru/starksoft/simplemessage/MessageTemplate;", "(Landroid/app/Activity;Ljava/lang/CharSequence;Lru/starksoft/simplemessage/MessageTemplate;)V", "messageData", "Lru/starksoft/simplemessage/MessageData;", "backgroundColor", "color", "", "build", "Lru/starksoft/simplemessage/SimpleMessage;", "getMessageRecordByTemplate", "messageType", "Lru/starksoft/simplemessage/MessageType;", "persistent", "", "progress", "show", "", "textColor", "simple-message_release"})
    public static final class Builder {
        private final MessageData messageData;
        private final Activity activity;

        /*
         * Enabled aggressive block sorting
         */
        private final MessageData getMessageRecordByTemplate(CharSequence message, MessageTemplate template) {
            MessageData messageData;
            MessageTemplate messageTemplate = template;
            if (messageTemplate != null) {
                switch (SimpleMessage$Builder$WhenMappings.$EnumSwitchMapping$0[messageTemplate.ordinal()]) {
                    case 1: {
                        messageData = MessageData.Companion.createErrorPersistent(message);
                        return messageData;
                    }
                    case 2: {
                        messageData = MessageData.Companion.createError(message);
                        return messageData;
                    }
                    case 3: {
                        messageData = MessageData.Companion.createNormalWithProgress(message);
                        return messageData;
                    }
                    case 4: {
                        messageData = MessageData.Companion.createNormal(message);
                        return messageData;
                    }
                    case 5: {
                        messageData = MessageData.Companion.createSuccess(message);
                        return messageData;
                    }
                }
            }
            messageData = new MessageData(null, 0, 0, false, false, null, 63, null);
            return messageData;
        }

        @NotNull
        public final Builder textColor(@ColorInt int color) {
            this.messageData.setTextColor(color);
            return this;
        }

        @NotNull
        public final Builder backgroundColor(@ColorInt int color) {
            this.messageData.setBackgroundColor(color);
            return this;
        }

        @NotNull
        public final Builder progress(boolean progress) {
            this.messageData.setProgress(progress);
            return this;
        }

        @NotNull
        public final Builder persistent(boolean persistent) {
            this.messageData.setPersistent(persistent);
            return this;
        }

        @NotNull
        public final Builder messageType(@NotNull MessageType messageType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)messageType), (String)"messageType");
            this.messageData.setMessageType(messageType);
            return this;
        }

        @NotNull
        public final SimpleMessage build() {
            return new SimpleMessage(this.activity, this.messageData, null);
        }

        public final void show() {
            this.build().show();
        }

        public Builder(@NotNull Activity activity, @NotNull CharSequence message, @Nullable MessageTemplate template) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.activity = activity;
            this.messageData = this.getMessageRecordByTemplate(message, template);
            this.messageData.setMessage(message);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lru/starksoft/simplemessage/SimpleMessage$Companion;", "", "()V", "TAG", "", "create", "Lru/starksoft/simplemessage/SimpleMessage$Builder;", "activity", "Landroid/app/Activity;", "message", "", "template", "Lru/starksoft/simplemessage/MessageTemplate;", "hide", "", "simple-message_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Builder create(@NotNull Activity activity, @NotNull CharSequence message) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            return this.create(activity, message, null);
        }

        @JvmStatic
        @NotNull
        public final Builder create(@NotNull Activity activity, @NotNull CharSequence message, @Nullable MessageTemplate template) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            return new Builder(activity, message, template);
        }

        public final void hide() {
            SimpleMessageManager.Companion.getInstance().hide();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

