/*
 * Decompiled with CFR 0.152.
 */
package ru.starksoft.simplemessage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.os.Build;
import android.support.annotation.Px;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.starksoft.simplemessage.BaseMessageLayout;
import ru.starksoft.simplemessage.MessageAnimationCallback;
import ru.starksoft.simplemessage.MessageData;
import ru.starksoft.simplemessage.R;
import ru.starksoft.simplemessage.util.UtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0003J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lru/starksoft/simplemessage/ToolBarMessageLayout;", "Lru/starksoft/simplemessage/BaseMessageLayout;", "context", "Landroid/content/Context;", "messageData", "Lru/starksoft/simplemessage/MessageData;", "(Landroid/content/Context;Lru/starksoft/simplemessage/MessageData;)V", "messageContent", "Landroid/widget/LinearLayout;", "messageTextView", "Landroid/widget/TextView;", "progressBar", "Landroid/widget/ProgressBar;", "toolbarBackground", "Landroid/view/View;", "createAnimationCallback", "Lru/starksoft/simplemessage/MessageAnimationCallback;", "createView", "", "getToolbarHeight", "", "getViewHeight", "hideSystemUi", "resizeView", "view", "newWidth", "newHeight", "showMessageDelay", "", "simple-message_release"})
@SuppressLint(value={"ViewConstructor"})
public final class ToolBarMessageLayout
extends BaseMessageLayout {
    private TextView messageTextView;
    private ProgressBar progressBar;
    private View toolbarBackground;
    private LinearLayout messageContent;

    @Override
    protected void createView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.message_toolbar, (ViewGroup)this);
        View view = this.findViewById(R.id.text);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.text)");
        this.messageTextView = (TextView)view;
        View view2 = this.findViewById(R.id.progress);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.progress)");
        this.progressBar = (ProgressBar)view2;
        View view3 = this.findViewById(R.id.toolbarBackground);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.toolbarBackground)");
        this.toolbarBackground = view3;
        View view4 = this.findViewById(R.id.messageContent);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.messageContent)");
        this.messageContent = (LinearLayout)view4;
        int statusBarHeight = this.getStatusBarHeight();
        View view5 = this.toolbarBackground;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarBackground");
        }
        this.resizeView(view5, -1, statusBarHeight);
        LinearLayout linearLayout = this.messageContent;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageContent");
        }
        LinearLayout linearLayout2 = this.messageContent;
        if (linearLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageContent");
        }
        int n = linearLayout2.getPaddingLeft();
        LinearLayout linearLayout3 = this.messageContent;
        if (linearLayout3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageContent");
        }
        int n2 = linearLayout3.getPaddingRight();
        LinearLayout linearLayout4 = this.messageContent;
        if (linearLayout4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageContent");
        }
        linearLayout.setPadding(n, statusBarHeight, n2, linearLayout4.getPaddingBottom());
        int backgroundColor = this.messageData.getBackgroundColor();
        if (backgroundColor != 0) {
            this.setBackgroundColor(backgroundColor);
        } else if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
            this.setBackgroundColor(window.getStatusBarColor());
        }
        TextView textView = this.messageTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageTextView");
        }
        textView.setText(this.messageData.getMessage());
        int textColor = this.messageData.getTextColor();
        TextView textView2 = this.messageTextView;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageTextView");
        }
        textView2.setTextColor(textColor);
        boolean progress = this.messageData.isProgress();
        ProgressBar progressBar = this.progressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        UtilKt.setVisibility((View)progressBar, progress);
        if (progress) {
            ProgressBar progressBar2 = this.progressBar;
            if (progressBar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            }
            progressBar2.getIndeterminateDrawable().setColorFilter(textColor, PorterDuff.Mode.SRC_IN);
        }
    }

    private final void resizeView(View view, int newWidth, int newHeight) {
        try {
            view.setLayoutParams((ViewGroup.LayoutParams)view.getLayoutParams().getClass().getDeclaredConstructor(Integer.TYPE, Integer.TYPE).newInstance(newWidth, newHeight));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected int getViewHeight() {
        return this.getToolbarHeight() + this.getStatusBarHeight();
    }

    @Px
    private final int getToolbarHeight() {
        int n;
        TypedValue typedValue = new TypedValue();
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        if (context.getTheme().resolveAttribute(R.attr.actionBarSize, typedValue, true)) {
            int n2 = typedValue.data;
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            n = TypedValue.complexToDimensionPixelSize((int)n2, (DisplayMetrics)resources.getDisplayMetrics());
        } else {
            n = UtilKt.dpToPx(56);
        }
        return n;
    }

    @Override
    public void hideSystemUi() {
    }

    @Override
    @NotNull
    protected MessageAnimationCallback createAnimationCallback() {
        return new MessageAnimationCallback(this){
            final /* synthetic */ ToolBarMessageLayout this$0;

            public void onShowAnimationStart() {
                this.this$0.animateContentIn(ToolBarMessageLayout.access$getToolbarBackground$p(this.this$0), (View)ToolBarMessageLayout.access$getMessageTextView$p(this.this$0), (View)ToolBarMessageLayout.access$getProgressBar$p(this.this$0));
            }

            public void onShowAnimationEnd() {
            }

            public void onHideAnimationStart() {
                this.this$0.animateContentOut(ToolBarMessageLayout.access$getToolbarBackground$p(this.this$0), (View)ToolBarMessageLayout.access$getMessageTextView$p(this.this$0), (View)ToolBarMessageLayout.access$getProgressBar$p(this.this$0));
            }

            public void onHideAnimationEnd() {
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    public long showMessageDelay() {
        return 0L;
    }

    public ToolBarMessageLayout(@NotNull Context context, @NotNull MessageData messageData) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)messageData, (String)"messageData");
        super(context, messageData);
    }

    public static final /* synthetic */ View access$getToolbarBackground$p(ToolBarMessageLayout $this) {
        View view = $this.toolbarBackground;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarBackground");
        }
        return view;
    }

    public static final /* synthetic */ void access$setToolbarBackground$p(ToolBarMessageLayout $this, View view) {
        $this.toolbarBackground = view;
    }

    public static final /* synthetic */ TextView access$getMessageTextView$p(ToolBarMessageLayout $this) {
        TextView textView = $this.messageTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageTextView");
        }
        return textView;
    }

    public static final /* synthetic */ void access$setMessageTextView$p(ToolBarMessageLayout $this, TextView textView) {
        $this.messageTextView = textView;
    }

    public static final /* synthetic */ ProgressBar access$getProgressBar$p(ToolBarMessageLayout $this) {
        ProgressBar progressBar = $this.progressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        return progressBar;
    }

    public static final /* synthetic */ void access$setProgressBar$p(ToolBarMessageLayout $this, ProgressBar progressBar) {
        $this.progressBar = progressBar;
    }
}

