/*
 * Decompiled with CFR 0.152.
 */
package ru.starksoft.simplemessage;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.annotation.UiThread;
import android.support.design.animation.AnimationUtils;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.accessibility.AccessibilityManager;
import android.widget.FrameLayout;
import ru.starksoft.simplemessage.Message;
import ru.starksoft.simplemessage.MessageAnimationCallback;
import ru.starksoft.simplemessage.MessageData;
import ru.starksoft.simplemessage.SimpleMessageManager;

public abstract class BaseMessageLayout
extends FrameLayout
implements Message {
    public static final int EVENT_SHOW = 0;
    public static final int EVENT_HIDE = 1;
    public static final long VIEW_ANIMATION_DURATION = 250L;
    public static final long CONTENT_ANIMATION_DURATION = 300L;
    private static final String TAG = "BaseMessageLayout";
    @NonNull
    protected final MessageData messageData;
    private final AccessibilityManager accessibilityManager;
    private final MessageAnimationCallback messageAnimationCallback = this.createAnimationCallback();
    private final SimpleMessageManager.Callback managerCallback = new SimpleMessageManager.Callback(){

        @Override
        public void show() {
            BaseMessageLayout.this.handler.sendMessage(BaseMessageLayout.this.handler.obtainMessage(0, (Object)BaseMessageLayout.this));
        }

        @Override
        public void dismiss() {
            BaseMessageLayout.this.handler.sendMessage(BaseMessageLayout.this.handler.obtainMessage(1, (Object)BaseMessageLayout.this));
        }
    };
    @Nullable
    private Message.OnDismissListener onDismissListener;
    @Nullable
    private OnLayoutChangeListener onLayoutChangeListener;
    private boolean isDismissing;
    private final Handler handler = new Handler(Looper.getMainLooper(), message -> {
        switch (message.what) {
            case 0: {
                ((BaseMessageLayout)message.obj).showView();
                return true;
            }
            case 1: {
                ((BaseMessageLayout)message.obj).hideView();
                return true;
            }
        }
        return false;
    });

    public BaseMessageLayout(@NonNull Context context, @NonNull MessageData messageData) {
        super(context);
        this.messageData = messageData;
        this.accessibilityManager = (AccessibilityManager)ContextCompat.getSystemService((Context)context, AccessibilityManager.class);
        this.createView();
    }

    protected abstract void createView();

    @NonNull
    protected abstract MessageAnimationCallback createAnimationCallback();

    @Px
    protected abstract int getViewHeight();

    @Override
    public void setOnDismissListener(@Nullable Message.OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
    }

    @Override
    @UiThread
    public void show() {
        this.isDismissing = false;
        SimpleMessageManager.getInstance().show(this, this.messageData.isPersistent() ? 0 : 3000);
    }

    @Override
    public void hide() {
        this.isDismissing = true;
        SimpleMessageManager.getInstance().hide(this);
    }

    @Override
    public boolean isDismissing() {
        return this.isDismissing;
    }

    @NonNull
    private View getDecorView() {
        return this.getWindow().getDecorView();
    }

    @NonNull
    protected Window getWindow() {
        return ((Activity)this.getContext()).getWindow();
    }

    private void showView() {
        Log.d((String)TAG, (String)(this.hashCode() + " showView() called"));
        if (this.isDismissing) {
            throw new IllegalStateException();
        }
        ViewGroup target = (ViewGroup)this.getDecorView();
        ViewParent parent = this.getParent();
        if (parent == null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, this.getViewHeight());
            target.addView((View)this, (ViewGroup.LayoutParams)layoutParams);
        }
        if (ViewCompat.isLaidOut((View)this)) {
            if (this.shouldAnimate()) {
                this.animateViewIn();
            } else {
                this.messageAnimationCallback.onShowAnimationEnd();
            }
        } else {
            this.setOnLayoutChangeListener((view, left, top, right, bottom) -> {
                this.setOnLayoutChangeListener(null);
                if (this.shouldAnimate()) {
                    this.animateViewIn();
                } else {
                    this.messageAnimationCallback.onShowAnimationEnd();
                }
            });
        }
    }

    private void hideView() {
        this.isDismissing = true;
        Log.d((String)TAG, (String)(this.hashCode() + " hideView() called"));
        this.animateViewOut();
    }

    @Override
    public void hideSystemUi() {
        View decorView = this.getDecorView().getRootView();
        decorView.setSystemUiVisibility(1);
        decorView.setOnSystemUiVisibilityChangeListener(visibility -> this.setSystemUiVisibility(1));
    }

    @Override
    public void showSystemUi() {
        View decorView = this.getDecorView();
        decorView.setSystemUiVisibility(0);
        decorView.setOnSystemUiVisibilityChangeListener(null);
    }

    void setOnLayoutChangeListener(@Nullable OnLayoutChangeListener onLayoutChangeListener) {
        this.onLayoutChangeListener = onLayoutChangeListener;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.onLayoutChangeListener != null) {
            this.onLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
        }
    }

    private void animateViewIn() {
        if (this.isDismissing) {
            throw new IllegalStateException();
        }
        int translationYBottom = -this.getTranslationYTop();
        this.setTranslationY(translationYBottom);
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{translationYBottom, 0});
        animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animator.setDuration(250L);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                BaseMessageLayout.this.messageAnimationCallback.onShowAnimationStart();
            }

            public void onAnimationEnd(Animator animator) {
                BaseMessageLayout.this.messageAnimationCallback.onShowAnimationEnd();
            }
        });
        animator.addUpdateListener(a -> this.setTranslationY(((Integer)a.getAnimatedValue()).intValue()));
        animator.start();
    }

    private void animateViewOut() {
        if (!this.isDismissing) {
            throw new IllegalStateException();
        }
        int translationYBottom = -this.getTranslationYTop();
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{0, translationYBottom});
        animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animator.setDuration(250L);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                BaseMessageLayout.this.messageAnimationCallback.onHideAnimationStart();
            }

            public void onAnimationEnd(Animator animator) {
                BaseMessageLayout.this.messageAnimationCallback.onHideAnimationEnd();
                BaseMessageLayout.this.onViewHidden();
            }
        });
        animator.addUpdateListener(a -> this.setTranslationY(((Integer)a.getAnimatedValue()).intValue()));
        animator.start();
    }

    private void onViewHidden() {
        if (!this.isDismissing) {
            throw new IllegalStateException();
        }
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this);
        }
        Log.d((String)TAG, (String)(this.hashCode() + " onViewHidden() called"));
        this.isDismissing = false;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismissed();
        }
    }

    protected void animateContentIn(View ... views) {
        if (views == null) {
            return;
        }
        for (View view : views) {
            view.setAlpha(0.0f);
            view.animate().alpha(1.0f).setDuration(300L).setStartDelay(100L).start();
        }
    }

    protected void animateContentOut(View ... views) {
        if (views == null) {
            return;
        }
        for (View view : views) {
            view.setAlpha(1.0f);
            view.animate().alpha(0.0f).setDuration(300L).start();
        }
    }

    private int getTranslationYTop() {
        return this.getHeight();
    }

    private boolean shouldAnimate() {
        return true;
    }

    @Px
    protected final int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @Override
    @NonNull
    public SimpleMessageManager.Callback getCallback() {
        return this.managerCallback;
    }

    @Override
    @NonNull
    public MessageData getMessageData() {
        return this.messageData;
    }

    static interface OnLayoutChangeListener {
        public void onLayoutChange(@NonNull View var1, int var2, int var3, int var4, int var5);
    }
}

