/*
 * Decompiled with CFR 0.152.
 */
package ru.starksoft.simplemessage;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.starksoft.simplemessage.Message;
import ru.starksoft.simplemessage.MessageData;
import ru.starksoft.simplemessage.MessageTemplate;
import ru.starksoft.simplemessage.MessageType;
import ru.starksoft.simplemessage.SimpleMessage$Builder$WhenMappings;
import ru.starksoft.simplemessage.SimpleMessage$WhenMappings;
import ru.starksoft.simplemessage.SimpleMessageManager;
import ru.starksoft.simplemessage.StatusBarMessageLayout;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\u0006\u0010\u000f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lru/starksoft/simplemessage/SimpleMessage;", "", "activity", "Landroid/app/Activity;", "messageData", "Lru/starksoft/simplemessage/MessageData;", "messageType", "Lru/starksoft/simplemessage/MessageType;", "(Landroid/app/Activity;Lru/starksoft/simplemessage/MessageData;Lru/starksoft/simplemessage/MessageType;)V", "view", "Lru/starksoft/simplemessage/Message;", "getMessageImplByType", "hide", "", "observeLifecycle", "show", "Builder", "Companion", "simple-message_release"})
public final class SimpleMessage {
    private final Activity activity;
    private final Message view;
    private static final String TAG = "SimpleMessage";
    public static final Companion Companion = new Companion(null);

    private final void observeLifecycle() {
        if (this.activity instanceof AppCompatActivity) {
            ((AppCompatActivity)this.activity).getLifecycle().addObserver(new LifecycleObserver(){

                @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                public final void destroy() {
                    SimpleMessageManager.Companion.getInstance().destroy();
                    Log.d((String)"SimpleMessage", (String)"destroy() called");
                }
            });
        }
    }

    public final void show() {
        this.view.show();
    }

    public final void hide() {
        this.view.hide();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Message getMessageImplByType(MessageType messageType, Activity activity, MessageData messageData) {
        switch (SimpleMessage$WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
            case 1: {
                return new StatusBarMessageLayout((Context)activity, messageData);
            }
            case 2: {
                String string = "Not implemented";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private SimpleMessage(Activity activity, MessageData messageData, MessageType messageType) {
        Activity activity2;
        SimpleMessage simpleMessage = this;
        if (activity == null) {
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        simpleMessage.activity = activity2 = activity;
        this.view = this.getMessageImplByType(messageType, activity, messageData);
        this.observeLifecycle();
    }

    public /* synthetic */ SimpleMessage(@NotNull Activity activity, @NotNull MessageData messageData, @NotNull MessageType messageType, DefaultConstructorMarker $constructor_marker) {
        this(activity, messageData, messageType);
    }

    @JvmStatic
    @NotNull
    public static final Builder create(@NotNull Activity activity, @NotNull CharSequence message) {
        return Companion.create(activity, message);
    }

    @JvmStatic
    @NotNull
    public static final Builder create(@NotNull Activity activity, @NotNull CharSequence message, @Nullable MessageTemplate template) {
        return Companion.create(activity, message, template);
    }

    @JvmStatic
    @NotNull
    public static final Builder create(@NotNull Activity activity, @NotNull CharSequence message, @NotNull MessageType messageType, @Nullable MessageTemplate template) {
        return Companion.create(activity, message, messageType, template);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u00002\b\b\u0001\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00002\b\b\u0001\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/starksoft/simplemessage/SimpleMessage$Builder;", "", "activity", "Landroid/app/Activity;", "message", "", "messageType", "Lru/starksoft/simplemessage/MessageType;", "template", "Lru/starksoft/simplemessage/MessageTemplate;", "(Landroid/app/Activity;Ljava/lang/CharSequence;Lru/starksoft/simplemessage/MessageType;Lru/starksoft/simplemessage/MessageTemplate;)V", "messageData", "Lru/starksoft/simplemessage/MessageData;", "backgroundColor", "color", "", "build", "Lru/starksoft/simplemessage/SimpleMessage;", "getMessageRecordByTemplate", "persistent", "", "progress", "show", "", "textColor", "simple-message_release"})
    public static final class Builder {
        private final MessageData messageData;
        private final Activity activity;
        private final MessageType messageType;

        /*
         * Enabled aggressive block sorting
         */
        private final MessageData getMessageRecordByTemplate(CharSequence message, MessageTemplate template) {
            MessageData messageData;
            MessageTemplate messageTemplate = template;
            if (messageTemplate != null) {
                switch (SimpleMessage$Builder$WhenMappings.$EnumSwitchMapping$0[messageTemplate.ordinal()]) {
                    case 1: {
                        messageData = MessageData.Companion.createErrorPersistent(message);
                        return messageData;
                    }
                    case 2: {
                        messageData = MessageData.Companion.createError(message);
                        return messageData;
                    }
                    case 3: {
                        messageData = MessageData.Companion.createNormalWithProgress(message);
                        return messageData;
                    }
                    case 4: {
                        messageData = MessageData.Companion.createNormal(message);
                        return messageData;
                    }
                    case 5: {
                        messageData = MessageData.Companion.createSuccess(message);
                        return messageData;
                    }
                }
            }
            messageData = new MessageData(null, 0, 0, false, false, 31, null);
            return messageData;
        }

        @NotNull
        public final Builder textColor(@ColorInt int color) {
            this.messageData.setTextColor(color);
            return this;
        }

        @NotNull
        public final Builder backgroundColor(@ColorInt int color) {
            this.messageData.setBackgroundColor(color);
            return this;
        }

        @NotNull
        public final Builder progress(boolean progress) {
            this.messageData.setProgress(progress);
            return this;
        }

        @NotNull
        public final Builder persistent(boolean persistent) {
            this.messageData.setPersistent(persistent);
            return this;
        }

        @NotNull
        public final SimpleMessage build() {
            return new SimpleMessage(this.activity, this.messageData, this.messageType, null);
        }

        public final void show() {
            this.build().show();
        }

        public Builder(@NotNull Activity activity, @NotNull CharSequence message, @NotNull MessageType messageType, @Nullable MessageTemplate template) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)((Object)messageType), (String)"messageType");
            this.activity = activity;
            this.messageType = messageType;
            this.messageData = this.getMessageRecordByTemplate(message, template);
            this.messageData.setMessage(message);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lru/starksoft/simplemessage/SimpleMessage$Companion;", "", "()V", "TAG", "", "create", "Lru/starksoft/simplemessage/SimpleMessage$Builder;", "activity", "Landroid/app/Activity;", "message", "", "template", "Lru/starksoft/simplemessage/MessageTemplate;", "messageType", "Lru/starksoft/simplemessage/MessageType;", "simple-message_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Builder create(@NotNull Activity activity, @NotNull CharSequence message) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            return this.create(activity, message, MessageType.STATUS_BAR, null);
        }

        @JvmStatic
        @NotNull
        public final Builder create(@NotNull Activity activity, @NotNull CharSequence message, @Nullable MessageTemplate template) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            return this.create(activity, message, MessageType.STATUS_BAR, template);
        }

        @JvmStatic
        @NotNull
        public final Builder create(@NotNull Activity activity, @NotNull CharSequence message, @NotNull MessageType messageType, @Nullable MessageTemplate template) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)((Object)messageType), (String)"messageType");
            return new Builder(activity, message, messageType, template);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

