/*
 * Decompiled with CFR 0.152.
 */
package ru.starksoft.simplemessage;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.design.animation.AnimationUtils;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.accessibility.AccessibilityManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.simplemessage.R;
import ru.starksoft.simplemessage.Message;
import ru.starksoft.simplemessage.MessageRecord;
import ru.starksoft.simplemessage.SimpleMessageManager;
import ru.starksoft.simplemessage.util.Util;

@SuppressLint(value={"ViewConstructor"})
final class StatusBarMessageLayout
extends LinearLayout
implements Message {
    public static final int EVENT_SHOW = 0;
    public static final int EVENT_HIDE = 1;
    public static final int PADDING_LEFT_RIGHT = Util.dpToPx(8);
    private static final String TAG = "StatusBarMessageLayout";
    private final MessageRecord messageRecord;
    private final AccessibilityManager accessibilityManager;
    @Nullable
    private Message.OnDismissListener onDismissListener;
    @Nullable
    private OnLayoutChangeListener onLayoutChangeListener;
    private TextView messageTextView;
    private ProgressBar progressBar;
    private boolean isDismissing;
    private final Handler handler = new Handler(Looper.getMainLooper(), message -> {
        switch (message.what) {
            case 0: {
                ((StatusBarMessageLayout)message.obj).showView();
                return true;
            }
            case 1: {
                ((StatusBarMessageLayout)message.obj).hideView();
                return true;
            }
        }
        return false;
    });
    private final SimpleMessageManager.Callback managerCallback = new SimpleMessageManager.Callback(){

        @Override
        public void show() {
            StatusBarMessageLayout.this.handler.sendMessage(StatusBarMessageLayout.this.handler.obtainMessage(0, (Object)StatusBarMessageLayout.this));
        }

        @Override
        public void dismiss() {
            StatusBarMessageLayout.this.handler.sendMessage(StatusBarMessageLayout.this.handler.obtainMessage(1, (Object)StatusBarMessageLayout.this));
        }
    };

    public StatusBarMessageLayout(@NonNull Context context, @NonNull MessageRecord messageRecord) {
        super(context);
        this.messageRecord = messageRecord;
        this.accessibilityManager = (AccessibilityManager)ContextCompat.getSystemService((Context)context, AccessibilityManager.class);
        this.init();
    }

    @Override
    public void setOnDismissListener(@Nullable Message.OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
    }

    @Override
    @UiThread
    public void show() {
        this.isDismissing = false;
        SimpleMessageManager.getInstance().show(this, this.messageRecord.isPersistent() ? 0 : 3000);
    }

    @Override
    public void hide() {
        this.isDismissing = true;
        SimpleMessageManager.getInstance().hide(this);
    }

    @Override
    public boolean isDismissing() {
        return this.isDismissing;
    }

    @NonNull
    private View getDecorView() {
        return this.getWindow().getDecorView();
    }

    @NonNull
    private Window getWindow() {
        return ((Activity)this.getContext()).getWindow();
    }

    private void showView() {
        Log.d((String)TAG, (String)(this.hashCode() + " showView() called"));
        if (this.isDismissing) {
            throw new IllegalStateException();
        }
        ViewGroup target = (ViewGroup)this.getDecorView();
        ViewParent parent = this.getParent();
        if (parent == null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, this.getStatusBarHeightInPixels());
            target.addView((View)this, (ViewGroup.LayoutParams)layoutParams);
        }
        if (ViewCompat.isLaidOut((View)this)) {
            if (this.shouldAnimate()) {
                this.animateViewIn();
            } else {
                this.onViewShown();
            }
        } else {
            this.setOnLayoutChangeListener((view, left, top, right, bottom) -> {
                this.setOnLayoutChangeListener(null);
                if (this.shouldAnimate()) {
                    this.animateViewIn();
                } else {
                    this.onViewShown();
                }
            });
        }
    }

    private void hideView() {
        this.isDismissing = true;
        Log.d((String)TAG, (String)(this.hashCode() + " hideView() called"));
        this.animateViewOut();
    }

    @Override
    public void hideSystemUi() {
        View decorView = this.getDecorView().getRootView();
        decorView.setSystemUiVisibility(1);
        decorView.setOnSystemUiVisibilityChangeListener(visibility -> this.setSystemUiVisibility(1));
    }

    @Override
    public void showSystemUi() {
        View decorView = this.getDecorView();
        this.getDecorView().setSystemUiVisibility(0);
        decorView.setOnSystemUiVisibilityChangeListener(null);
    }

    public void setOnLayoutChangeListener(@Nullable OnLayoutChangeListener onLayoutChangeListener) {
        this.onLayoutChangeListener = onLayoutChangeListener;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.onLayoutChangeListener != null) {
            this.onLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
        }
    }

    private void animateViewIn() {
        if (this.isDismissing) {
            throw new IllegalStateException();
        }
        int translationYBottom = -this.getTranslationYTop();
        this.setTranslationY(translationYBottom);
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{translationYBottom, 0});
        animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animator.setDuration(250L);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                StatusBarMessageLayout.this.animateContentIn(new View[]{StatusBarMessageLayout.this.messageTextView, StatusBarMessageLayout.this.progressBar});
            }

            public void onAnimationEnd(Animator animator) {
                StatusBarMessageLayout.this.onViewShown();
            }
        });
        animator.addUpdateListener(a -> {
            int currentAnimatedIntValue = (Integer)a.getAnimatedValue();
            this.setTranslationY(currentAnimatedIntValue);
        });
        animator.start();
    }

    private void animateViewOut() {
        if (!this.isDismissing) {
            throw new IllegalStateException();
        }
        int translationYBottom = -this.getTranslationYTop();
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{0, translationYBottom});
        animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animator.setDuration(250L);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                StatusBarMessageLayout.this.animateContentOut(new View[]{StatusBarMessageLayout.this.messageTextView, StatusBarMessageLayout.this.progressBar});
            }

            public void onAnimationEnd(Animator animator) {
                StatusBarMessageLayout.this.onViewHidden();
            }
        });
        animator.addUpdateListener(a -> {
            int currentAnimatedIntValue = (Integer)a.getAnimatedValue();
            this.setTranslationY(currentAnimatedIntValue);
        });
        animator.start();
    }

    private void onViewShown() {
        Log.d((String)TAG, (String)(this.hashCode() + " onViewShown() called"));
    }

    private void onViewHidden() {
        if (!this.isDismissing) {
            throw new IllegalStateException();
        }
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this);
        }
        Log.d((String)TAG, (String)(this.hashCode() + " onViewHidden() called"));
        this.isDismissing = false;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismissed();
        }
    }

    private void animateContentIn(View ... views) {
        if (views == null) {
            return;
        }
        for (View view : views) {
            view.setAlpha(0.0f);
            view.animate().alpha(1.0f).setDuration(300L).setStartDelay(100L).start();
        }
    }

    private void animateContentOut(View ... views) {
        if (views == null) {
            return;
        }
        for (View view : views) {
            view.setAlpha(1.0f);
            view.animate().alpha(0.0f).setDuration(300L).start();
        }
    }

    private int getTranslationYTop() {
        int translationY = this.getHeight();
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            translationY += ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin;
        }
        return translationY;
    }

    private boolean shouldAnimate() {
        return true;
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.message_statusbar, (ViewGroup)this);
        this.setGravity(17);
        this.setPadding(PADDING_LEFT_RIGHT, 0, PADDING_LEFT_RIGHT, 0);
        this.messageTextView = (TextView)this.findViewById(R.id.text);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress);
        if (this.messageRecord != null) {
            int backgroundColor = this.messageRecord.getBackgroundColor();
            if (backgroundColor != 0) {
                this.setBackgroundColor(backgroundColor);
            } else if (Build.VERSION.SDK_INT >= 21) {
                this.setBackgroundColor(this.getWindow().getStatusBarColor());
            }
            this.messageTextView.setText(this.messageRecord.getMessage());
            int textColor = this.messageRecord.getTextColor();
            this.messageTextView.setTextColor(textColor);
            boolean progress = this.messageRecord.getProgress();
            Util.setVisibility((View)this.progressBar, progress);
            if (progress) {
                this.progressBar.getIndeterminateDrawable().setColorFilter(textColor, PorterDuff.Mode.SRC_IN);
            }
        }
    }

    public int getStatusBarHeightInPixels() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @Override
    @NonNull
    public SimpleMessageManager.Callback getCallback() {
        return this.managerCallback;
    }

    @Override
    @NonNull
    public MessageRecord getMessageRecord() {
        return this.messageRecord;
    }

    static interface OnLayoutChangeListener {
        public void onLayoutChange(@NonNull View var1, int var2, int var3, int var4, int var5);
    }
}

