/*
 * Decompiled with CFR 0.152.
 */
package ru.starksoft.simplemessage;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.util.Log;
import ru.starksoft.simplemessage.Message;
import ru.starksoft.simplemessage.MessageRecord;
import ru.starksoft.simplemessage.util.Util;

final class SimpleMessageManager {
    private static final String TAG = "SimpleMessageManager";
    private static final SimpleMessageManager INSTANCE = new SimpleMessageManager();
    private final Handler handler = new Handler(Looper.getMainLooper());
    private Message currentMessage;

    private SimpleMessageManager() {
    }

    @NonNull
    public static SimpleMessageManager getInstance() {
        return INSTANCE;
    }

    @UiThread
    public void show(@NonNull Message message, int duration) {
        if (this.currentMessage == null) {
            int messageDelay = 0;
            if (Build.VERSION.SDK_INT >= 26) {
                // empty if block
            }
            this.showInternal(message, duration, messageDelay);
        } else {
            MessageRecord currentMessageRecord = this.currentMessage.getMessageRecord();
            MessageRecord newMessageRecord = message.getMessageRecord();
            if (newMessageRecord.equals(currentMessageRecord)) {
                Log.d((String)TAG, (String)"show: trying to show the same message.. skipping");
            } else if (!this.currentMessage.isDismissing()) {
                this.handler.removeCallbacksAndMessages(null);
                this.currentMessage.setOnDismissListener(() -> {
                    this.currentMessage.setOnDismissListener(null);
                    this.showInternal(message, duration, 0);
                });
                this.currentMessage.getCallback().dismiss();
            } else {
                Log.d((String)TAG, (String)"show: we are in dismissing state");
            }
        }
    }

    public void hide(@NonNull Message message) {
        message.getCallback().dismiss();
        message.showSystemUi();
    }

    private void showInternal(@NonNull Message message, int duration, int messageDelay) {
        this.currentMessage = Util.checkNotNull(message);
        this.currentMessage.hideSystemUi();
        Callback callback = this.currentMessage.getCallback();
        callback.show();
        if (duration > 0) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler.postDelayed(() -> {
                if (callback != null) {
                    callback.dismiss();
                    this.currentMessage.showSystemUi();
                    this.currentMessage = null;
                }
            }, (long)duration);
        }
    }

    public void destroy() {
        this.handler.removeCallbacksAndMessages(null);
        this.currentMessage = null;
    }

    public static interface Callback {
        public void show();

        public void dismiss();
    }
}

