/*
 * Decompiled with CFR 0.152.
 */
package ru.starksoft.simplemessage;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import org.jetbrains.annotations.NotNull;
import ru.starksoft.simplemessage.MessageRecord;
import ru.starksoft.simplemessage.SimpleMessageManager;
import ru.starksoft.simplemessage.StatusBarMessageLayout;
import ru.starksoft.simplemessage.util.Util;

public final class SimpleMessage {
    private static final String TAG = "SimpleMessage";
    @NonNull
    private final Activity activity;
    private final StatusBarMessageLayout view;

    private SimpleMessage(@NonNull Activity activity, @NonNull MessageRecord messageRecord) {
        this.activity = Util.checkNotNull(activity);
        this.view = new StatusBarMessageLayout((Context)activity, messageRecord);
        this.observeLifecycle();
    }

    @NonNull
    public static Builder create(@NonNull Activity activity, @NonNull CharSequence message) {
        return new Builder(activity, message, 0);
    }

    @NonNull
    public static Builder create(@NonNull Activity activity, @NonNull CharSequence message, int template) {
        return new Builder(activity, message, template);
    }

    private void observeLifecycle() {
        if (this.activity instanceof AppCompatActivity) {
            ((AppCompatActivity)this.activity).getLifecycle().addObserver(new LifecycleObserver(){

                @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                void destroy() {
                    SimpleMessageManager.getInstance().destroy();
                    Log.d((String)SimpleMessage.TAG, (String)"destroy() called");
                }
            });
        }
    }

    public void show() {
        this.view.show();
    }

    public void hide() {
        this.view.hide();
    }

    public static final class Builder {
        private final MessageRecord messageRecord;
        @NonNull
        private final Activity activity;

        public Builder(@NonNull Activity activity, @NonNull CharSequence message, int template) {
            this.activity = activity;
            this.messageRecord = this.getMessageRecordByTemplate(message, template);
            this.messageRecord.setMessage(message);
        }

        @NonNull
        private MessageRecord getMessageRecordByTemplate(@NonNull CharSequence message, int template) {
            switch (template) {
                case 5: {
                    return MessageRecord.createErrorPersistent(message);
                }
                case 4: {
                    return MessageRecord.createError(message);
                }
                case 2: {
                    return MessageRecord.createNormalWithProgress(message);
                }
                case 1: {
                    return MessageRecord.createNormal(message);
                }
                case 3: {
                    return MessageRecord.createSuccess(message);
                }
            }
            return new MessageRecord();
        }

        @NotNull
        public Builder textColor(@ColorInt int color) {
            this.messageRecord.setTextColor(color);
            return this;
        }

        @NotNull
        public Builder backgroundColor(@ColorInt int color) {
            this.messageRecord.setBackgroundColor(color);
            return this;
        }

        @NotNull
        public Builder progress(boolean progress) {
            this.messageRecord.setProgress(progress);
            return this;
        }

        @NotNull
        public Builder persistent(boolean persistent) {
            this.messageRecord.setPersistent(persistent);
            return this;
        }

        @NonNull
        public SimpleMessage build() {
            return new SimpleMessage(this.activity, this.messageRecord);
        }

        public void show() {
            this.build().show();
        }
    }
}

