/*
 * Decompiled with CFR 0.152.
 */
package ru.reliabletech.zuul.swagger;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import ru.reliabletech.zuul.swagger.ServicesSwaggerInfo;
import ru.reliabletech.zuul.swagger.SwaggerService;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Primary
@Component
public class ZuulSwaggerResourceProvider
implements SwaggerResourcesProvider {
    private static final Logger log = LoggerFactory.getLogger(ZuulSwaggerResourceProvider.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ServicesSwaggerInfo servicesSwaggerInfo;
    @Autowired
    private SwaggerService swaggerService;

    public List<SwaggerResource> get() {
        return this.servicesSwaggerInfo.getRouteNames().stream().map(route -> {
            ObjectNode swaggerDocumentation = this.swaggerService.getSwaggerDoc((String)route);
            return this.generateSwaggerDocumentationResource((String)route, "/api-docs?route=" + route, swaggerDocumentation.get("swagger").asText());
        }).collect(Collectors.toList());
    }

    private SwaggerResource generateSwaggerDocumentationResource(String name, String location, String version) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion(version);
        return swaggerResource;
    }
}

