/*
 * Decompiled with CFR 0.152.
 */
package ru.reliabletech.zuul.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import ru.reliabletech.zuul.swagger.NotFoundException;
import ru.reliabletech.zuul.swagger.ServicesSwaggerInfo;
import ru.reliabletech.zuul.swagger.SwaggerService;

@RestController
public class ZuulSwaggerController {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ServicesSwaggerInfo servicesSwaggerInfo;
    @Autowired
    private SwaggerService swaggerService;

    @GetMapping(value={"/api-docs"})
    public JsonNode getApiDocs(@RequestParam(value="route") String route) {
        String path = this.servicesSwaggerInfo.getServicePath(route).orElseThrow(NotFoundException::new).replace("/**", "");
        ObjectNode swaggerDocumentation = this.swaggerService.getSwaggerDoc(route);
        swaggerDocumentation.set("host", (JsonNode)new TextNode(""));
        swaggerDocumentation.set("basePath", (JsonNode)new TextNode(this.servicesSwaggerInfo.getPrefix() + path));
        return swaggerDocumentation;
    }
}

